<?php

namespace App\Models\User;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PackageReview extends Model
{
  use HasFactory;
  protected $table= 'user_package_reviews';
  protected $fillable = ['user_id', 'package_id', 'rating', 'comment','customer_id'];

  public function user()
  {
    return $this->belongsTo('App\Models\User', 'user_id', 'id');
  }

  public function reviewOfPackage()
  {
    return $this->belongsTo('App\Models\User\Package');
  }
  public function customer()
  {
    return $this->belongsTo('App\Models\Customer','customer_id');
  }
}
