<?php

namespace App\Models\User;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PackagePlan extends Model
{
  use HasFactory;
  protected $table = 'user_package_plans';
  protected $fillable = [
    'language_id',
    'package_id',
    'day_number',
    'start_time',
    'end_time',
    'title',
    'plan',
    'user_id'
  ];

  public function planLang()
  {
    return $this->belongsTo('App\Models\User\Language');
  }

  public function ownedByPackage()
  {
    return $this->belongsTo('App\Models\User\Package');
  }
}
