<?php

namespace App\Models\User;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PackageLocation extends Model
{
  use HasFactory;
  protected $table = 'user_package_locations';
  protected $fillable = [
    'language_id',
    'package_id',
    'name',
    'latitude',
    'longitude',
    'user_id'
  ];

  public function locationLang()
  {
    return $this->belongsTo('App\Models\User\Language');
  }

  public function packageInfo()
  {
    return $this->belongsTo('App\Models\User\Package', 'package_id', 'id');
  }
}
