<?php

namespace App\Models\User;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PackageContent extends Model
{
  use HasFactory;
  protected $table = 'user_package_contents';
  protected $fillable = [
    'language_id',
    'package_category_id',
    'package_id',
    'title',
    'slug',
    'description',
    'meta_keywords',
    'meta_description',
    'user_id'
  ];

  public function packageCategory()
  {
    return $this->belongsTo('App\Models\User\PackageCategory');
  }

  public function package()
  {
    return $this->belongsTo('App\Models\User\Package');
  }

  public function packageContentLang()
  {
    return $this->belongsTo('App\Models\User\Language');
  }
}
