<?php

namespace App\Models\User;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Facades\Auth;

class PackageCategory extends Model
{
  use HasFactory;

  protected $table = 'user_package_categories';
  protected $fillable = [
    'language_id',
    'name',
    'slug',
    'status',
    'serial_number',
    'user_id',
    'indx',
    'image'
  ];

  public function packageCategoryLang()
  {
    return $this->belongsTo('App\Models\User\Language');
  }


  public function packageContentList()
  {
    return $this->hasMany('App\Models\User\Package', 'package_category_index', 'indx');
  }
  
  public function scopeActive(Builder $query)
  {
    return $query->where('status', 1);
  }

  public function scopeOwnedByUser(Builder $query)
  {
    return $query->where('user_id', Auth::guard('web')->user()->id);
  }
  public function languagewiseCategories()
  {
    return $this->hasMany(PackageCategory::class, 'indx', 'indx');
  }

  protected static function boot()
  {
    parent::boot();
    static::deleting(function ($amenity) {
      $amenity->languagewiseCategories()->delete();
    });
  }
}
