<?php

namespace App\Models\User;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PackageBooking extends Model
{
  use HasFactory;
  protected $table = 'user_package_bookings';

  protected $fillable = [
    'booking_number',
    'user_id',
    'user_membership_id',
    'customer_id',
    'customer_name',
    'customer_email',
    'customer_phone',
    'package_id',
    'visitors',
    'subtotal',
    'discount',
    'grand_total',
    'currency_symbol',
    'currency_symbol_position',
    'currency_text',
    'currency_text_position',
    'payment_method',
    'gateway_type',
    'attachment',
    'invoice',
    'payment_status',
    'actual_total',
    'payment_offline_status',
    'tax',
    'fee'
  
  ];

  public function tourPackage()
  {
    return $this->belongsTo('App\Models\User\Package', 'package_id', 'id');
  }

  public function packageBookedByUser()
  {
    return $this->belongsTo('App\Models\User', 'user_id', 'id');
  }
  public function packageBookedByCustomer()
  {
    return $this->belongsTo('App\Models\Customer', 'customer_id', 'id');
  }
}
