<?php

namespace App\Models\User;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Package extends Model
{
  use HasFactory;
  protected $table = 'user_packages';
  protected $fillable = [
    'slider_imgs',
    'featured_img',
    'plan_type',
    'max_persons',
    'number_of_days',
    'pricing_type',
    'package_price',
    'email',
    'phone',
    'avg_rating',
    'is_featured',
    'user_id',
    'package_category_index'
  ];

  public function packageContent()
  {
    return $this->hasMany('App\Models\User\PackageContent');
  }

  public function packageLocationList()
  {
    return $this->hasMany('App\Models\User\PackageLocation');
  }

  public function packagePlanList()
  {
    return $this->hasMany('App\Models\User\PackagePlan');
  }

  public function tourPackageBooking()
  {
    return $this->hasMany('App\Models\User\PackageBooking');
  }

  public function packageReview()
  {
    return $this->hasMany('App\Models\User\PackageReview');
  }
  public function packageCategory()
  {
    return $this->hasOne(PackageCategory::class, 'indx', 'package_category_index');
  }
}
