<?php

namespace App\Models\User;

use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MailTemplate extends Model
{
    use HasFactory;
    protected $table = 'user_mail_templates';
    protected $fillable = ['mail_subject', 'mail_body'];

    public $timestamps = false;

    // accessor
    public function getMailTypeAttribute($value)
    {
        return str_replace('_', ' ', $value);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
