<?php

namespace App\Models\User\Journal;

use App\Models\User\Language;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;



class BlogCategory extends Model
{
  use HasFactory;

  protected $table = 'user_blog_categories';

  /**
   * The attributes that are mass assignable.
   *
   * @var array
   */
  protected $fillable = ['language_id','user_id', 'name', 'status', 'serial_number', 'slug', 'indx'];

  public function categoryLang()
  {
    return $this->belongsTo(Language::class,'language_id');
  }

  public function blogInfo()
  {
    return $this->hasMany(BlogInformation::class);
  }

  public function blogContentList()
  {
    return $this->hasMany('App\Models\User\Journal\Blog', 'category_index', 'indx');
  }

  public function scopeActive(Builder $query)
  {
    return $query->where('status', 1);
  }

  public function languagewiseCategories()
  {
    return $this->hasMany(BlogCategory::class, 'indx', 'indx');
  }
  
  protected static function boot()
  {
    parent::boot();
    static::deleting(function ($category) {
      $category->languagewiseCategories()->delete();
    });
  }
}
