<?php

namespace App\Models\User\Journal;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Blog extends Model
{
  use HasFactory;

  public $table ="user_blogs";

  /**
   * The attributes that are mass assignable.
   *
   * @var array
   */
  protected $fillable = ['user_id','language_id','image', 'serial_number', 'category_index'];

  public function information()
  {
    return $this->hasMany('App\Models\User\Journal\BlogInformation');
  }
  
  public function categories()
  {
    return $this->belongsTo(BlogCategory::class, 'indx', 'category_index');
  }

}
