<?php

namespace App\Models\User\HomePage;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SectionHeading extends Model
{
  use HasFactory;
  protected $table = 'user_section_headings';
  protected $fillable = [
    'language_id',
    'user_id',
    'room_section_title',
    'room_section_subtitle',
    'room_section_text',
    'room_category_section_title',
    'room_category_section_image',
    'service_section_title',
    'service_section_subtitle',
    'video_section_title',
    'video_section_subtitle',
    'video_section_button',
    'video_section_button_url',
    'video_section_video_url',
    'video_section_image',
    'video_section_image_two',
    'package_section_title',
    'package_section_subtitle',
    'facility_section_title',
    'facility_section_subtitle',
    'facility_section_image',
    'facility_section_image_two',
    'facility_section_image_three',
    'testimonial_section_title',
    'testimonial_section_subtitle',
    'testimonial_section_image',
    'faq_section_title',
    'faq_section_subtitle',
    'faq_section_image',
    'blog_section_title',
    'blog_section_subtitle',
    'intro_img',
    'intro_image_two',
    'intro_image_three',
    'intro_primary_title',
    'intro_secondary_title',
    'intro_text',
    'intro_button_text',
    'intro_button_url',
    'intro_member_image',
    'hero_section_image',
    'hero_section_title',
    'hero_section_subtitle',
    'hero_section_button_name',
    'hero_section_button_url',
    'hero_section_video_link',
    'about_page_about_section_title',
    'about_page_about_section_text',
    'about_page_about_section_image',
    'about_page_facility_section_title',
    'about_page_facility_section_image',
    'about_page_testimonial_section_title',
    'about_page_testimonial_section_text',
    'statistics_section_image',

    'latest_room_section_title',
    'latest_package_section_title',
    'intro_member_image_show',
    'package_category_section_title', 
  ];

  public function headingLang()
  {
    return $this->belongsTo('App\Models\User\Language');
  }
}
