<?php

namespace App\Models\User;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GalleryCategory extends Model
{
  use HasFactory;
  protected $table = 'user_gallery_categories';
  protected $fillable = [
    'language_id',
    'name',
    'status',
    'serial_number',
    'user_id'
  ];

  public function galleryCategoryLang()
  {
    return $this->belongsTo('App\Models\User\Language');
  }

  public function galleryImgList()
  {
    return $this->hasMany('App\Models\User\Gallery');
  }
}
