<?php

namespace App\Models\User;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Gallery extends Model
{
  use HasFactory;
  protected $table = 'user_gallery_images';

  protected $fillable = [
    'language_id',
    'gallery_category_id',
    'gallery_img',
    'title',
    'serial_number',
    'user_id'
  ];

  public function galleryImgLang()
  {
    return $this->belongsTo('App\Models\User\Language');
  }

  public function galleryCategory()
  {
    return $this->belongsTo('App\Models\User\GalleryCategory', 'gallery_category_id', 'id');
  }
}
