<?php

namespace App\Models;

use App\Models\User\AdditionalSection;
use App\Models\User\AdditionalSectionContent;
use App\Models\User\Advertisement;
use App\Models\User\BasicExtended;
use App\Models\User\BasicSetting;
use App\Models\User\CustomPage\Page;
use App\Models\User\CustomPage\PageContent;
use App\Models\User\FooterQuickLink;
use App\Models\User\FooterText;
use App\Models\User\HomePage\AboutUsSection;
use App\Models\User\HomePage\ActionSection;
use App\Models\User\HomePage\Fact\CountInformation;
use App\Models\User\HomePage\Feature;
use App\Models\User\HomePage\HeroSection;
use App\Models\User\HomePage\NewsletterSection;
use App\Models\User\HomePage\SectionHeading;
use App\Models\User\HomePage\SectionTitle;
use App\Models\User\HomePage\Testimonial;
use App\Models\User\HomePage\VideoSection;
use App\Models\User\Journal\Blog;
use App\Models\User\Journal\BlogCategory;
use App\Models\User\Language;
use App\Models\User\Menu;
use App\Models\User\PageHeading;
use App\Models\User\Popup;
use App\Models\User\Social;
use App\Models\User\SEO;
use App\Models\User\FAQ;
use App\Models\User\Gallery;
use App\Models\User\GalleryCategory;
use App\Models\User\HomePage\Brand;
use App\Models\User\HomePage\Facility;
use App\Models\User\HomePage\HeroSlider;
use App\Models\User\HomePage\IntroCountInfo;
use App\Models\User\Journal\BlogInformation;
use App\Models\User\Subscriber;
use App\Models\User\MailTemplate;
use App\Models\User\RoomReview;
use App\Models\User\Section;
use App\Models\User\Service;
use App\Models\User\UserCustomDomain;
use App\Models\User\UserPermission;
use App\Models\User\UserQrCode;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class User extends Authenticatable
{
    use Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'first_name',
        'last_name',
        'email',
        'photo',
        'username',
        'password',
        'phone',
        'company_name',
        'city',
        'state',
        'address',
        'country',
        'status',
        'featured',
        'verification_link',
        'email_verified',
        'online_status',
        'pass_token'
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public function user_custom_domains() {
        return $this->hasMany('App\Models\User\UserCustomDomain','user_id');
    }

    public function page_heading(): HasOne
    {
        return $this->hasOne(PageHeading::class, 'user_id');
    }
    public function page_headings(): HasMany
    {
        return $this->hasMany(PageHeading::class, 'user_id');
    }
    public function custom_domains(): HasMany
    {
        return $this->hasMany(UserCustomDomain::class);
    }
    public function mail_templates(): HasMany
    {
        return $this->hasMany(MailTemplate::class);
    }

    public function memberships(): HasMany
    {
        return $this->hasMany(Membership::class, 'user_id');
    }

    public function basic_setting(): HasOne
    {
        return $this->hasOne(BasicSetting::class, 'user_id');
    }

    public function qr_codes(): HasMany
    {
        return $this->hasMany(UserQrCode::class, 'user_id');
    }

    public function counterInformations(): HasMany
    {
        return $this->hasMany(CountInformation::class, 'user_id');
    }

    public function faqs(): HasMany
    {
        return $this->hasMany(FAQ::class, 'user_id');
    }

    public function seos(): HasMany
    {
        return $this->hasMany(SEO::class, 'user_id');
    }

    public function testimonials(): HasMany
    {
        return $this->hasMany(Testimonial::class, 'user_id');
    }
    
    public function services(): HasMany
    {
        return $this->hasMany(Service::class, 'user_id');
    }

    public function galleries(): HasMany
    {
        return $this->hasMany(Gallery::class, 'user_id');
    }
    public function blogs(): HasMany
    {
        return $this->hasMany(Blog::class, 'user_id');
    }
    public function blog_contents(): HasMany
    {
        return $this->hasMany(BlogInformation::class, 'user_id');
    }

    public function blog_categories(): HasMany
    {
        return $this->hasMany(BlogCategory::class, 'user_id');
    }

    public function social_media(): HasMany
    {
        return $this->hasMany(Social::class, 'user_id');
    }

    public function languages()
    {
        return $this->hasMany(Language::class, 'user_id');
    }
    public function custom_pages(){
        return $this->hasMany(Page::class, 'user_id');
    }

    public function footer_quick_links()
    {
        return $this->hasMany(FooterQuickLink::class, 'user_id');
    }

    public function subscribers()
    {
        return $this->hasMany(Subscriber::class, 'user_id');
    }

    public function footer_texts(): HasMany
    {
        return $this->hasMany(FooterText::class, 'user_id');
    }

    public function menus(): HasMany
    {
        return $this->hasMany(Menu::class, 'user_id');
    }

    public function home_section(): HasOne
    {
        return $this->hasOne(SectionHeading::class, 'user_id');
    }
    
    public function section_headings(): hasMany
    {
        return $this->hasMany(SectionHeading::class, 'user_id');
    }


    public function hero_sections(): HasMany
    {
        return $this->hasMany(HeroSection::class, 'user_id');
    }

    public function sectionTitle(): HasOne
    {
        return $this->hasOne(SectionTitle::class, 'user_id');
    }

    public function announcementPopup(): HasMany
    {
        return $this->hasMany(Popup::class,'user_id');
    }

    public function videoSection(): HasOne
    {
        return $this->hasOne(VideoSection::class, 'user_id');
    }

    public function customPageInfo(): HasMany
    {
        return $this->hasMany(PageContent::class,'user_id');
    }

    public function newsletterSection(): HasOne
    {
        return $this->hasOne(NewsletterSection::class, 'user_id');
    }

    public function basic_extendeds(): HasMany
    {
        return $this->hasMany(BasicExtended::class,'user_id');
    }

    public function about_us_section(): HasMany
    {
        return $this->hasMany(AboutUsSection::class, 'user_id');
    }

    public function features(): HasMany
    {
        return $this->hasMany(Feature::class, 'user_id');
    }
    public function online_gateways(): HasMany
    {
       return $this->hasMany(\App\Models\User\PaymentGateway::class, 'user_id');
    }
    public function offline_gateways(): HasMany
    {
        return $this->hasMany(\App\Models\User\OfflineGateway::class, 'user_id');
    }
    public function actionSection(): HasOne
    {
        return $this->hasOne(ActionSection::class, 'user_id');
    }
    public function tickets()
    {
        return $this->hasMany('App\Models\User\UserTicket');
    }
    public function conversations()
    {
        return $this->hasMany('App\Models\User\UserConversation');
    }

    
    public function rooms()
    {
        return $this->hasMany('App\Models\User\Room');
    }

    public function room_categories()
    {
        return $this->hasMany('App\Models\User\RoomCategory');
    }

    public function room_amenities()
    {
        return $this->hasMany('App\Models\User\RoomAmenity');
    }
    public function roomBookingCoupons()
    {
    return $this->hasMany('App\Models\User\Coupon');
    }

    public function bookHotelRoom()
    {
        return $this->hasMany('App\Models\User\RoomBooking');
    }

    public function tourPackageBookings()
    {
        return $this->hasMany('App\Models\User\PackageBooking');
    }
    public function tourPackageBookingCoupons()
    {
        return $this->hasMany('App\Models\User\PackageCoupon');
    }
    public function tourPackages()
    {
        return $this->hasMany('App\Models\User\Package');
    }
    public function packageCategories()
    {
        return $this->hasMany('App\Models\User\PackageCategory');
    }
    public function packageCoupons()
    {
        return $this->hasMany('App\Models\User\PackageCoupon');
    }
    public function packageLocations()
    {
        return $this->hasMany('App\Models\User\PackageLocation','user_id');
    }
    public function packagePlans()
    {
        return $this->hasMany('App\Models\User\PackagePlan', 'user_id');
    }

    public function giveReviewForRoom()
    {
        return $this->hasMany('App\Models\User\RoomReview');
    }
    public function giveReviewForPackage()
    {
        return $this->hasMany('App\Models\User\PackageReview');
    }
    public function sections(){
        return $this->hasMany(Section::class,'user_id');
    }
    public function hero_sliders()
    {
        return $this->hasMany(HeroSlider::class, 'user_id');
    }
    public function brands()
    {
        return $this->hasMany(Brand::class, 'user_id');
    }
    public function gallery_categories()
    {
        return $this->hasMany(GalleryCategory::class, 'user_id');
    }
    public function counterInfos()
    {
        return $this->hasMany(IntroCountInfo::class, 'user_id');
    }
    public function permissions()
    {
        return $this->hasMany(UserPermission::class, 'user_id');
    }

    public function room_reviews()
    {
        return $this->hasMany(RoomReview::class, 'user_id');
    }
    public function facilities()
    {
        return $this->hasMany(Facility::class, 'user_id');
    }

    public function advertisements()
    {
        return $this->hasMany(Advertisement::class, 'user_id');
    }
    
    public function additional_sections()
    {
        return $this->hasMany(AdditionalSection::class, 'user_id');
    }


}
