<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Package extends Model
{
    public $table = "packages";

    protected $fillable = [
        'title',
        'slug',
        'price',
        'term',
        'featured',
        'is_trial',
        'recommended',
        'icon',
        'language_limit',
        'trial_days',
        'status',
        'storage_limit',
        'room_categories_limit',
        'room_booking_limit',
        'package_categories_limit',
        'room_limit',
        'package_booking_limit',
        'package_limit',
        'features',
        'room_booking_coupon_limit',
        'package_booking_coupon_limit',
        'blog_limit',
        'custom_page_limit',
        'meta_keywords',
        'meta_description',
    ];
    public function memberships()
    {
        return $this->hasMany('App\Models\Membership');
    }
}
