<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class Customer extends Authenticatable
{
    use HasFactory, Notifiable;

    public $table = "customers";

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'first_name',
        'last_name',
        'image',
        'username',
        'email',
        'email_verified_at',
        'password',
        'contact_number',
        'address',
        'city',
        'state',
        'country',
        'status',
        'verification_token',
        'edit_profile_status',
        'pass_token'
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];


    public function room_reviews()
    {
        return $this->hasMany(RoomReview::class, 'customer_id', 'id');
    }

    public function package_reviews()
    {
        return $this->hasMany(PackageReview::class, 'customer_id', 'id');
    }
    
    public function user()
    {
        return $this->belongsTo(User::class,'user_id');
    }

    public function roomBooked()
    {
        return $this->hasOne('App\Models\User\RoomBooking');
    }

}
