<?php

namespace App\Http\Requests;

use App\Rules\ImageMimeTypeRule;
use Illuminate\Foundation\Http\FormRequest;

class UserProfileRequest extends FormRequest
{
  /**
   * Determine if the user is authorized to make this request.
   *
   * @return bool
   */
  public function authorize()
  {
    return true;
  }

  /**
   * Get the validation rules that apply to the request.
   *
   * @return array
   */
  public function rules()
  {
    return [
      'image' => [
        'nullable',
         new ImageMimeTypeRule()
      ],
      'first_name' => 'required',
      'last_name' => 'required',
      'contact_number' => 'required',
      'address' => 'required',
      'city' => 'required',
      'country' => 'required'
    ];
  }
  public function messages()
  {
        $user = getUser();
        $keywords = get_keywords($user->id);
        return [
            'image.required' => $keywords['The image field is required.'] ?? __('The image field is required.'),
            'first_name.required' => $keywords['The first name is required.'] ?? __('The first name is required.'),
            'last_name.required' => $keywords['The last name field is required.'] ?? __('The last name field is required.'),
            'contact_number.required' => $keywords['The contact number field is required.'] ??  __('The contact number field is required.'),
            'address.required' => $keywords['The address field is required.'] ?? __('The address field is required.'),
            'city.required' => $keywords['The city field is required.'] ?? __('The city field is required.'),
            'country.required' => $keywords['The country field is required.'] ?? __('The country field is required.'),
        ];
  }
}
