<?php

namespace App\Http\Requests;

use App\Rules\MaxGuestsRoomRule;
use App\Rules\IsRoomAvailableRule;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Session;

class RoomBookingRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        if(!empty($this->dates) && !empty($this->room_id)){
            Session::put('room_booking_id_dates', 'room_id_' . $this->room_id . '_dates_' . str_replace(' ', '', $this->dates));
        }
        $ruleArray = [
            'dates' => [
                'required',
                new IsRoomAvailableRule($this->room_id)
            ],
            'nights' => 'required',
            'guests' => [
                'required',
                'numeric',
                'min:1',
                new MaxGuestsRoomRule($this->room_id),
            ],
            'paymentType' => 'required',
            'customer_name' => 'required',
            'customer_phone' => 'required',
            'customer_email' => 'required|email:rfc,dns'
        ];
        return $ruleArray;
    }
    public function messages()
    {
        $keywords = get_keywords(getUser()->id);
        return [
            'dates.required' => $keywords['The dates field is required.'] ?? __('The dates field is required.'),
            'nights.required' => $keywords['The nights field is required.'] ??  __('The nights field is required.'),
            'customer_name.required' => $keywords['The customer name field is required.'] ?? __('The customer name field is required.'),
            'customer_phone.required' => $keywords['The customer phone field is required.'] ?? __('The customer phone field is required.'),
            'customer_email.required' => $keywords['The customer email field is required.'] ?? __('The customer email field is required.'),
            'paymentType.required' => $keywords['The payment type field is required.'] ?? __('The payment type field is required.')
        ];
    }
}
