<?php

namespace App\Http\Requests\Package;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Request;

class PackageStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(): array
    {
        
        $features = $this->features ?? [];
        
        $this['tour_package'] = 0;
        $this['blog'] = 0;
        $this['custom_page'] = 0;
        
        if(in_array('Tour Package', $features)){
            $this['tour_package'] = 'selected';
        }
        if (in_array('Blog', $features)) {
            $this['blog'] = 'selected';
        }
        if (in_array('Custom Page', $features)) {
            $this['custom_page'] = 'selected';
        }
        
        return [
            
            'title'=> 'required|max:255',
            'term' => 'required',
            'price' => 'required',
            'status' => 'required',
            'room_categories_limit' => 'required',
            'room_booking_limit' => 'required',
            'room_booking_coupon_limit' => 'required',
            'room_limit' => 'required',
            'trial_days' => 'required_if:is_trial,1',
            'package_categories_limit' => 'required_if:tour_package,selected',
            'package_limit' => 'required_if:tour_package,selected',
            'package_booking_limit' => 'required_if:tour_package,selected',
            'package_booking_coupon_limit' => 'required_if:tour_package,selected',
            'blog_limit' => 'required_if:blog,selected',
            'custom_page_limit' => 'required_if:custom_page,selected',
            'language_limit'=>'required',
        ];
    }
    public function messages(): array
    {
        return [
            'trial_days.required_if' => 'Trial days is required',
        ];
    }
}
