<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;


class LanguageUpdateRequest extends FormRequest
{
  /**
   * Determine if the user is authorized to make this request.
   *
   * @return bool
   */
  public function authorize()
  {
    return true;
  }

  /**
   * Get the validation rules that apply to the request.
   *
   * @return array
   */
  public function rules(Request $request)
  {
  

    return [
      'name' => 'required',
      'code' => [
        'required',
        Rule::unique('user_languages')->ignore($request->language_id)
      ],
      'rtl' => 'required'
    ];
  }
  public function messages()
  {
    return [
      'rtl.required' => __('The direction field is required.')
    ];
  }
}
