<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class IntroSectionRequest extends FormRequest
{
  /**
   * Determine if the user is authorized to make this request.
   *
   * @return bool
   */
  public function authorize()
  {
    return true;
  }

  /**
   * Get the validation rules that apply to the request.
   *
   * @return array
   */
  public function rules()
  {
    return [
      'intro_primary_title' => 'required',
      'intro_secondary_title' => 'required',
      'intro_text' => 'required',
      'intro_img'=> 'required|image|mimes:jpeg,png,jpg|max:2048'
    ];
  }
}
