<?php

namespace App\Http\Controllers\User;

use App;
use App\Constants\Constant;
use App\Http\Controllers\Controller;
use App\Http\Helpers\Uploader;
use App\Models\Membership;
use App\Models\Package;
use App\Models\User\Language;
use App\Models\User\Package as UserPackage;
use App\Models\User\PackageBooking;
use App\Models\User\Room;
use App\Models\User\RoomBooking;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Mews\Purifier\Facades\Purifier;

class UserController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('setUserLang');
    }
    public function index()
    {
        $user = Auth::guard('web')->user();
        $language = Language::where('user_id', Auth::guard('web')->user()->id)->first();
        $data['user'] = $user;
        $data['galleries'] = $user->galleries()->where('language_id', $language->id)->count();
        $data['services'] = $user->services()->count();
        $data['blogs'] = $user->blogs()->count();


        $data['roomsCount'] = Room::where('user_id', $user->id)->count();
        $data['allRbCount'] = RoomBooking::where('user_id', $user->id)->count();
        $data['paidRbCount'] = RoomBooking::where('user_id', $user->id)->where('payment_status', 1)->count();
        $data['packagesCount'] = UserPackage::where('user_id', $user->id)->count();
        $data['allPbCount'] = PackageBooking::where('user_id', $user->id)->count();
        $data['paidPbCount'] = PackageBooking::where('user_id', $user->id)->where('payment_status', 1)->count();

        $data['memberships'] = Membership::query()->where('user_id', Auth::user()->id)
            ->orderBy('id', 'DESC')
            ->limit(10)->get();

        $data['users'] = [];

        $nextPackageCount = Membership::query()->where([
            ['user_id', Auth::guard('web')->user()->id],
            ['expire_date', '>=', Carbon::now()->toDateString()],
        ])->whereYear('start_date', '<>', '9999')->where('status', '<>', 2)->count();
        //current package
        $data['current_membership'] = Membership::query()->where([
            ['user_id', Auth::guard('web')->user()->id],
            ['start_date', '<=', Carbon::now()->toDateString()],
            ['expire_date', '>=', Carbon::now()->toDateString()],
        ])->where('status', 1)->whereYear('start_date', '<>', '9999')->first();
        if ($data['current_membership']) {
            $countCurrMem = Membership::query()->where([
                ['user_id', Auth::guard('web')->user()->id],
                ['start_date', '<=', Carbon::now()->toDateString()],
                ['expire_date', '>=', Carbon::now()->toDateString()],
            ])->where('status', '<>', 2)->whereYear('start_date', '<>', '9999')->count();
            if ($countCurrMem > 1) {
                $data['next_membership'] = Membership::query()->where([
                    ['user_id', Auth::guard('web')->user()->id],
                    ['start_date', '<=', Carbon::now()->toDateString()],
                    ['expire_date', '>=', Carbon::now()->toDateString()],
                ])->where('status', '<>', 2)->whereYear('start_date', '<>', '9999')->orderBy('id', 'DESC')->first();
            } else {
                $data['next_membership'] = Membership::query()->where([
                    ['user_id', Auth::guard('web')->user()->id],
                    ['start_date', '>', $data['current_membership']->expire_date],
                ])->whereYear('start_date', '<>', '9999')->where('status', '<>', 2)->first();
            }
            $data['next_package'] = $data['next_membership'] ? Package::query()->where('id', $data['next_membership']->package_id)->first() : null;
        }
        $data['current_package'] = $data['current_membership'] ? Package::query()->where('id', $data['current_membership']->package_id)->first() : null;
        $data['package_count'] = $nextPackageCount;

        //monthly room bookings 
        $data['monthy_room_bookings'] = RoomBooking::where('user_id',$user->id)->select(DB::raw('MONTH(created_at) month'), DB::raw('count(*) total'))->where('payment_status', 1)->groupBy('month')->whereYear('created_at', date('Y'))->get();
        $data['monthy_room_booking_incomes'] = RoomBooking::where('user_id', $user->id)->select(DB::raw('MONTH(created_at) month'), DB::raw('sum(grand_total) total'))->where('payment_status', 1)->groupBy('month')->whereYear('created_at', date('Y'))->get();

        //monthly package bookings 
        $data['monthy_package_bookings'] = PackageBooking::where('user_id', $user->id)->select(DB::raw('MONTH(created_at) month'), DB::raw('count(*) total'))->where('payment_status', 1)->groupBy('month')->whereYear('created_at', date('Y'))->get();
        $data['monthy_package_booking_incomes'] = PackageBooking::where('user_id', $user->id)->select(DB::raw('MONTH(created_at) month'), DB::raw('sum(grand_total) total'))->where('payment_status', 1)->groupBy('month')->whereYear('created_at', date('Y'))->get();

        return view('user.dashboard', $data);
    }

    public function status(Request $request)
    {
        $user = Auth::user();
        $user->online_status = $request->value;
        $user->save();
        $msg = '';
        if ($request->value == 1) {
            $msg = "Profile has been made visible";
        } else {
            $msg = "Profile has been hidden";
        }
        Session::flash('success', $msg);
        return "success";
    }

    public function profile()
    {
        $user = Auth::user();
        return view('user.edit-profile', compact('user'));
    }

    public function profileupdate(Request $request)
    {

        $request->validate([
            'photo' =>  Auth::user()->photo ? 'nullable' : 'required',
            'first_name' => 'required',
            'last_name' => 'required',
            'company_name' => 'required',
            'username' => 'required|unique:users,username,' . Auth::user()->id,
            'phone' => 'required',
            'country' => 'required',
        ]);

        $input = $request->except('address');
        $input['address'] =  Purifier::clean($request->address, 'youtube');
        $data = Auth::user();
        if ($request->hasFile('photo')) {
            $profile = $request->file('photo');
            $input['photo'] = Uploader::profile_image(public_path(Constant::WEBSITE_TENANT_IMAGE), $profile,  $data->photo);
        }
        $data->update($input);

        Session::flash('success', __('Updated Successfully'));
        return "success";
    }

    public function resetform()
    {
        return view('user.reset');
    }

    public function reset(Request $request)
    {
        $request->validate([
            'current_password' => 'required',
            'new_password' => 'required',
            'confirmation_password' => 'required',
        ]);
        $user = Auth::user();
        if ($request->current_password) {
            if (Hash::check($request->current_password, $user->password)) {
                if ($request->new_password == $request->confirmation_password) {
                    $input['password'] = Hash::make($request->new_password);
                } else {
                    return back()->with('err', __('Confirm password does not match.'));
                }
            } else {
                return back()->with('err', __('Current password Does not match.'));
            }
        }

        $user->update($input);
        Session::flash('success', 'Successfully change your password');
        return back();
    }

    public function changePass()
    {
        return view('user.changepass');
    }

    public function updatePassword(Request $request)
    {
        $rules = [
            'old_password' => 'required',
            'password' => 'required|confirmed',
            'password_confirmation' => 'required',
        ];

        $messages = [
            'password.required' => __('The new password field is required'),
            'password.confirmed' => __("Password does'nt match"),
            'password_confirmation.required' => __("The password confirmation field is required."),
        ];
        $validator = Validator::make($request->all(), $rules, $messages);
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator);
        }

        // if given old password matches with the password of this authenticated user...
        if (Hash::check($request->old_password, Auth::guard('web')->user()->password)) {
            $oldPassMatch = 'matched';
        } else {
            $oldPassMatch = 'not_matched';
        }
        if ($validator->fails() || $oldPassMatch == 'not_matched') {
            if ($oldPassMatch == 'not_matched') {
                $validator->errors()->add('oldPassMatch', true);
            }
            return redirect()->route('user.changePass')
                ->withErrors($validator);
        }

        // updating password in database...
        $user = App\Models\User::findOrFail(Auth::guard('web')->user()->id);
        $user->password = bcrypt($request->password);
        $user->save();

        Session::flash('success', __('Password changed successfully'));
        return redirect()->back();
    }

    public function shippingdetails()
    {
        $user = Auth::user();
        return view('user.shipping_details', compact('user'));
    }

    public function shippingupdate(Request $request)
    {
        $request->validate([
            "shpping_fname" => 'required',
            "shpping_lname" => 'required',
            "shpping_email" => 'required',
            "shpping_number" => 'required',
            "shpping_city" => 'required',
            "shpping_state" => 'required',
            "shpping_address" => 'required',
            "shpping_country" => 'required',
        ]);

        Auth::user()->update($request->all());
        Session::flash('success', __('Updated Successfully'));
        return back();
    }

    public function billingdetails()
    {
        $user = Auth::user();
        return view('user.billing_details', compact('user'));
    }

    public function billingupdate(Request $request)
    {
        $request->validate([
            "billing_fname" => 'required',
            "billing_lname" => 'required',
            "billing_email" => 'required',
            "billing_number" => 'required',
            "billing_city" => 'required',
            "billing_state" => 'required',
            "billing_address" => 'required',
            "billing_country" => 'required',
        ]);

        Auth::user()->update($request->all());

        Session::flash('success', __('Updated Successfully'));
        return back();
    }

    public function changeTheme(Request $request)
    {
        return redirect()->back()->withCookie(cookie()->forever('user-theme', $request->theme));
    }

    public function pdfTest()
    {
        $pdf = Pdf::loadView('frontend.shop.invoice', compact());
        return $pdf->stream('invoice.pdf');
    }
}
