<?php

namespace App\Http\Controllers\User;

use App\Models\BasicSetting;
use Illuminate\Http\Request;
use App\Models\BasicExtended;
use App\Models\User\Subscriber;
use Mews\Purifier\Facades\Purifier;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Session;

class SubscriberController extends Controller
{
    public function index(Request $request)
    {
        $term = $request->term;
        $data['subscs'] = Subscriber::where('user_id', Auth::guard('web')->user()->id)
            ->when($term, function ($query, $term) {
                return $query->where('email', 'LIKE', '%' . $term . '%');
            })->orderBy('id', 'DESC')->paginate(10);
        return view('user.subscribers.index', $data);
    }

    public function store(Request $request, $domain)
    {
        $user = getUser();
        $request->validate([
            'email' => [
                'required',
                function ($attribute, $value, $fail) use ($user) {
                    $subscriber = Subscriber::where([
                        ['email', $value],
                        ['user_id', $user->id]
                    ])->get();
                    if ($subscriber->count() > 0) {
                        Session::flash('error', __('This email is already subscribed'));
                        $fail( ':attribute already subscribed for this user');
                    }
                },
            ],
        ]);
        $request['user_id'] = $user->id;
        Subscriber::create($request->all());

        Session::flash('success', __('You have successfully subscribed to our newsletter.'));
        return redirect()->back();
    }

    public function mailsubscriber()
    {
        return view('user.subscribers.mail');
    }

    public function subscsendmail(Request $request)
    {
        $request->validate([
            'subject' => 'required',
            'message' => 'required'
        ]);
        $sub = $request->subject;
        $msg = Purifier::clean($request->message, 'youtube');
        $subscs = Subscriber::where('user_id', Auth::guard('web')->user()->id)->get();
        $info = \App\Models\User\BasicSetting::where('user_id', Auth::guard('web')->user()->id)->select('email', 'from_name')->first();

        $email = $info->email ?? Auth::user()->email;
        $name = $info->from_name ?? Auth::user()->company_name;
        $settings = BasicSetting::first();

        $subscs = Subscriber::all();
        $be = BasicExtended::first();

        $smtp = [
            'transport' => 'smtp',
            'host' => $be->smtp_host,
            'port' => $be->smtp_port,
            'encryption' => $be->encryption,
            'username' => $be->smtp_username,
            'password' => $be->smtp_password,
            'timeout' => null,
            'auth_mode' => null,
        ];
        Config::set('mail.mailers.smtp', $smtp);

        if ($be->is_smtp == 1) {
            try {
                //Server settings
                Mail::send([], [], function ($message) use ($be, $msg, $sub, $subscs, $name) {
                    $fromMail = $be->from_mail;
                    $fromName = $name;
                    // Add BCC recipients
                    foreach ($subscs as $recipient) {
                        $message->subject($sub);
                        $message->from($fromMail, $fromName);
                        $message->html($msg, 'text/html');
                        $message->bcc($recipient->email);
                    }
                });
            } catch (\Exception $e) {
                dd($e);
            }
        } else {
            try {
                //Recipients
                Mail::send([], [], function ($message) use ($be, $msg, $sub, $subscs, $name) {
                    $fromMail = $be->from_mail;
                    $fromName = $name;
                    // Add BCC recipients
                    foreach ($subscs as $recipient) {

                        $message->subject($sub);
                        $message->from($fromMail, $fromName);
                        $message->html($msg, 'text/html');
                        $message->bcc($recipient->email);
                    }
                });
            } catch (\Exception $e) {
                dd($e);
            }
        }

        Session::flash('success', __('Mail sent successfully'));
        return back();
    }


    public function delete(Request $request)
    {
        Subscriber::findOrFail($request->subscriber_id)->delete();
        Session::flash('success', __('Deleted Successfully'));
        return back();
    }

    public function bulkDelete(Request $request)
    {
        $ids = $request->ids;
        foreach ($ids as $id) {
            Subscriber::findOrFail($id)->delete();
        }
        Session::flash('success', __('Deleted Successfully'));
        return "success";
    }
}
