<?php

namespace App\Http\Controllers\User;

use App\Constants\Constant;
use App\Http\Controllers\Controller;
use App\Http\Helpers\Uploader;
use App\Models\Customer;
use App\Models\User;
use App\Models\User\Package;
use App\Models\User\PackageBooking;
use App\Models\User\Room;
use App\Models\User\RoomBooking;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;

class RegisteredUserController extends Controller
{
  public function index(Request $request)
  {
    $searchKey = null;
    if ($request->filled('info')) {
      $searchKey = $request['info'];
    }
    $users = Customer::when($searchKey, function ($query, $searchKey) {
      return $query->where('username', 'like', '%' . $searchKey . '%')
        ->orWhere('email', 'like', '%' . $searchKey . '%');
    })
      ->where('user_id', Auth::guard('web')->user()->id)
      ->orderBy('id', 'desc')
      ->paginate(10);

    return view('user.registered-users.index', compact('users'));
  }

  public function updateAccountStatus(Request $request, $id)
  {
    $user = Customer::where('id', $id)->where('user_id', Auth::guard('web')->user()->id)->firstOrFail();
    if ($request['account_status'] == 1) {
      $user->update(['status' => 1]);
    } else {
      $user->update(['status' => 0]);
    }

    Session::flash('success', __('Updated Successfully'));
    return redirect()->back();
  }

  public function show($id)
  {
    $userInfo = Customer::where('id', $id)->where('user_id', Auth::guard('web')->user()->id)->firstOrFail();
    $information['userInfo'] = $userInfo;
    return view('user.registered-users.details', $information);
  }

  public function changePassword($id)
  {
    $userInfo = Customer::where('id', $id)->where('user_id', Auth::guard('web')->user()->id)->firstOrFail();
    return view('user.registered-users.change-password', compact('userInfo'));
  }

  public function updatePassword(Request $request, $id)
  {
    $rules = [
      'new_password' => 'required|confirmed',
      'new_password_confirmation' => 'required'
    ];
    $messages = [
      'new_password.confirmed' => __('Password confirmation does not match.'),
      'new_password_confirmation.required' => __('The confirm new password field is required.')
    ];
    $validator = Validator::make($request->all(), $rules, $messages);
    if ($validator->fails()) {
      return Response::json([
        'errors' => $validator->getMessageBag()->toArray()
      ], 400);
    }
    $user = Customer::where('id', $id)->where('user_id', Auth::guard('web')->user()->id)->firstOrFail();
    $user->update([
      'password' => Hash::make($request->new_password)
    ]);

    Session::flash('success', __('Updated Successfully'));
    return 'success';
  }

  public function destroy(Request $request, $id)
  {
    $customer = Customer::where('id', $id)->where('user_id', Auth::guard('web')->user()->id)->with('user')->firstOrFail();
    $roomBookings = RoomBooking::where('customer_id', $customer->id)->get();
    if ($roomBookings->count() > 0) {
      foreach ($roomBookings as $key => $rb) {
        Uploader::remove(public_path(Constant::WEBSITE_ROOM_BOOKING_ATTACHMENTS), $rb->attachment);
        Uploader::remove(public_path(Constant::WEBSITE_ROOM_BOOKING_INVOICE), $rb->invoice);
        $rb->delete();
      }
    }
    $rooms = Room::where('user_id', Auth::guard('web')->user()->id)->with('roomReview')->get();
    if ($rooms->count() > 0) {
      foreach ($rooms as $roomReview) {
        foreach ($roomReview->roomReview as $review) {
          $review->delete();
        }
      }
    }
    $packageBookings = PackageBooking::where('customer_id', $customer->id)->where('user_id', Auth::guard('web')->user()->id)->get();
    // delete package booking
    if ($packageBookings->count() > 0) {
      foreach ($packageBookings as $key => $rb) {
        Uploader::remove(public_path(Constant::WEBSITE_PACKAGE_BOOKING_ATTACHMENTS), $rb->attachment);
        Uploader::remove(public_path(Constant::WEBSITE_PACKAGE_BOOKING_INVOICE), $rb->invoice);
        $rb->delete();
      }
    }

    //  delete room review
    $packages = Package::where('user_id', Auth::guard('web')->user()->id)->with('packageReview')->get();
    if ($packages->count() > 0) {
      foreach ($packages as $packageReview) {
        foreach ($packageReview->packageReview as $review) {
          $review->delete();
        }
      }
    }
    Uploader::remove(public_path(Constant::WEBSITE_CUSTOMER), $customer->image);
    $customer->delete();

    Session::flash('success', __('Deleted Successfully'));
    return back();
  }

  public function bulkDestroy(Request $request)
  {
    $ids = $request->ids;
    foreach ($ids as $id) {
      $customer = Customer::where('id', $id)->where('user_id', Auth::guard('web')->user()->id)->with('user')->firstOrFail();
      $roomBookings = RoomBooking::where('customer_id', $customer->id)->get();
      //  delete room booking
      if ($roomBookings->count() > 0) {
        foreach ($roomBookings as $key => $rb) {
          Uploader::remove(public_path(Constant::WEBSITE_ROOM_BOOKING_ATTACHMENTS), $rb->attachment);
          Uploader::remove(public_path(Constant::WEBSITE_ROOM_BOOKING_INVOICE), $rb->invoice);
          $rb->delete();
        }
      }

      //  delete room review
      $rooms = Room::where('user_id', Auth::guard('web')->user()->id)->with('roomReview')->get();
      if ($rooms->count() > 0) {
        foreach ($rooms as $roomReview) {
          foreach ($roomReview->roomReview as $review) {
            $review->delete();
          }
        }
      }
      $packageBookings = PackageBooking::where('customer_id', $customer->id)->where('user_id', Auth::guard('web')->user()->id)->get();
      // delete package booking
      if ($packageBookings->count() > 0) {
        foreach ($packageBookings as $key => $rb) {
          Uploader::remove(public_path(Constant::WEBSITE_PACKAGE_BOOKING_ATTACHMENTS), $rb->attachment);
          Uploader::remove(public_path(Constant::WEBSITE_PACKAGE_BOOKING_INVOICE), $rb->invoice);
          $rb->delete();
        }
      }

      //  delete room review
      $packages = Package::where('user_id', Auth::guard('web')->user()->id)->with('packageReview')->get();
      if ($packages->count() > 0) {
        foreach ($packages as $packageReview) {
          foreach ($packageReview->packageReview as $review) {
            $review->delete();
          }
        }
      }
      Uploader::remove(public_path(Constant::WEBSITE_CUSTOMER), $customer->image);
      $customer->delete();
    }

    Session::flash('success', __('Deleted Successfully'));
    return back();
  }

  public function emailStatus(Request $request)
  {
    $user = Customer::where('id', $request->user_id)->where('user_id', Auth::guard('web')->user()->id)->firstOrFail();
    $user->update([
      'email_verified_at' => $request->email_verified == 1 ? Carbon::now() : NULL,
    ]);

    Session::flash('success', __('Updated Successfully'));
    return back();
  }
  public function secret_login($id)
  {
    $customer = Customer::where('id', $id)->first();
    Auth::guard('customer')->login($customer);
    $user = User::where('id', $customer->user_id)->first();
    return redirect()->route('customer.dashboard', $user->username);
  }
}
