<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use App\Http\Helpers\UserPermissionHelper;
use App\Models\User\MailTemplate;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Mews\Purifier\Facades\Purifier;

class MailTemplateController extends Controller
{
  public function index()
  {
    $user = Auth::guard('web')->user();
    $permissions = UserPermissionHelper::packagePermission($user->id);
    $permissions = json_decode($permissions, true);
    $templates = MailTemplate::where('user_id', Auth::guard('web')->user()->id)->get();
    $templates = $templates->reject(function($template)use($permissions){
      if(isset($permissions) && !in_array('Tour Package', $permissions)){
        return in_array($template->getRawOriginal('mail_type'), [
          "package_booking_for_online_gateway",
          "package_booking_for_offline_gateway",
          "package_booking_payment_cancelled",
          "package_booking_payment_received"
        ]);
      }
    });
    return view('user.settings.email.templates', compact('templates'));
  }

  public function edit($id)
  {
    $templateInfo = MailTemplate::where('user_id', Auth::guard('web')->user()->id)->findOrFail($id);
    return view('user.settings.email.edit-template', compact('templateInfo'));
  }

  public function update(Request $request, $id)
  {
    $rules = [
      'mail_subject' => 'required',
      'mail_body' => 'required'
    ];
    $validator = Validator::make($request->all(), $rules);

    if ($validator->fails()) {
      return redirect()->back()->withErrors($validator->errors());
    }
    MailTemplate::where('user_id', Auth::guard('web')->user()->id)->findOrFail($id)->update($request->except('mail_type', 'mail_body') + [
      'mail_body' => Purifier::clean($request->mail_body, 'youtube')
    ]);

    Session::flash('success', __('Updated Successfully'));
    return redirect()->back();
  }
}
