<?php

namespace App\Http\Controllers\User;

use App\Constants\Constant;
use App\Models\User\FAQ;
use App\Models\User\SEO;
use App\Models\User\Menu;
use App\Models\User\Room;
use App\Models\User\Popup;
use App\Models\User\Gallery;
use App\Models\User\Package;
use App\Models\User\Service;
use Illuminate\Http\Request;
use App\Models\User\Language;
use App\Models\User\FooterText;
use App\Models\User\RoomReview;
use App\Models\User\PackagePlan;
use App\Models\User\PageHeading;
use App\Models\User\RoomAmenity;
use App\Models\User\RoomBooking;
use App\Models\User\RoomContent;
use App\Models\User\Journal\Blog;
use App\Models\User\RoomCategory;
use App\Models\User\PackageReview;
use Illuminate\Support\Facades\DB;
use App\Models\User\HomePage\Brand;
use App\Models\User\PackageBooking;
use App\Models\User\PackageContent;
use App\Models\User\ServiceContent;
use App\Http\Controllers\Controller;
use App\Http\Helpers\Uploader;
use App\Models\User\CustomPage\Page;
use App\Models\User\FooterQuickLink;
use App\Models\User\GalleryCategory;
use App\Models\User\PackageCategory;
use App\Models\User\PackageLocation;
use Illuminate\Support\Facades\Auth;
use App\Models\User\HomePage\Facility;
use App\Models\User\HomePage\HeroSlider;
use App\Models\User\HomePage\Testimonial;
use App\Models\User\Journal\BlogCategory;
use App\Http\Requests\LanguageStoreRequest;
use App\Models\User\CustomPage\PageContent;
use App\Models\User\BasicExtended;
use App\Models\User\HomePage\IntroCountInfo;
use App\Models\User\HomePage\SectionHeading;
use App\Models\User\Journal\BlogInformation;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;


class LanguageController extends Controller
{
    public function index($lang = false)
    {
        $data['languages'] = Language::query()->where('user_id', Auth::guard('web')->user()->id)->get();
        return view('user.language.index', $data);
    }

    public function store(LanguageStoreRequest $request)
    {
        $lang = Language::where('user_id', Auth::guard('web')->user()->id)->firstOrFail();
        // then, store data in db
        $language = Language::create([
            'code' => $request->code,
            'name' => $request->name,
            'rtl' => $request->rtl,
            'keywords' => $lang->keywords,
            'added_type' => 'user',
            'user_id' => Auth::guard('web')->user()->id
        ]);
        //page headings Create
        $pageHeading = PageHeading::query()->where('user_id', Auth::guard('web')->user()->id)->where('language_id', $lang->id)->first()->toArray();
        unset($pageHeading['id']);
        array_walk($pageHeading, function (&$value, $key) use ($language) {
            if ($key == 'language_id') {
                $value = $language->id;
            }
        });
        PageHeading::create($pageHeading);

        $menus = '[{"text":"Home","href":"","icon":"empty","target":"_self","title":"","type":"home"},{"text":"Services","href":"","icon":"empty","target":"_self","title":"","type":"service"},{"text":"Rooms","href":"","icon":"empty","target":"_self","title":"","type":"room"},{"text":"Packages","href":"","icon":"empty","target":"_self","title":"","type":"package"},{"text":"Blog","href":"","icon":"empty","target":"_self","title":"","type":"blog"},{"text":"Gallery","href":"","icon":"empty","target":"_self","title":"","type":"gallery"},{"text":"Contact","href":"","icon":"empty","target":"_self","title":"","type":"contact"},{"type":"faq","text":"FAQ","href":"","target":"_self"}]';

        Menu::create([
            'user_id' => Auth::guard('web')->user()->id,
            'language_id' => $language->id,
            'menus' => $menus,
        ]);

        //===Section Heading create
        SectionHeading::create([
            "language_id" => $language->id,
            "user_id" => Auth::guard('web')->user()->id,
        ]);
        //===End Section Heading
        BasicExtended::create([
            'user_id' =>  Auth::guard('web')->user()->id,
            'language_id' => $language->id,
        ]);

        Session::flash('success', __('Created Successfully'));
        return 'success';
    }

    public function makeDefault($id)
    {
        // first, make other languages to non-default language
        Language::where('is_default', 1)->where('user_id', Auth::guard('web')->user()->id)->update(['is_default' => 0]);
        // second, make the selected language to default language
        $language = Language::where('user_id', Auth::guard('web')->user()->id)->findOrFail($id);
        $language->update(['is_default' => 1]);
        return back()->with('success', $language->name . ' ' . 'is set as default language.');
    }
    public function makeDashboardDefault($id)
    {
        Language::where('dashboard_default', 1)->where('user_id', Auth::guard('web')->user()->id)->update(['dashboard_default' => 0]);
        $language = Language::where('user_id', Auth::guard('web')->user()->id)->findOrFail($id);
        $language->update(['dashboard_default' => 1]);
        Session::put('user_lang', $language->code);
        return back()->with('success', $language->name . ' ' . 'is set as default language.');
    }
    public function edit($id)
    {
      
        if ($id > 0) {
            $data['language'] = Language::where('user_id', Auth::guard('web')->user()->id)->where('id', $id)->firstOrFail();
        }
        $data['id'] = $id;
        return view('user.language.edit', $data);
    }

    public function update(Request $request)
    {
        $language = Language::where('user_id', Auth::guard('web')->user()->id)->findOrFail($request->language_id);

        $rules = [
            'name' => 'required|max:255',
            'code' => [
                'required',
                'max:255',
                function ($attribute, $value, $fail) use ($language, $request) {
                    $langs = Language::where('user_id', Auth::guard('web')->user()->id)->where('id', '<>', $language->id)->get();
                    foreach ($langs as $key => $lang) {
                        if ($lang->code == $request->code) {
                            return $fail(__("Language code have to be unique"));
                        }
                    }
                }
            ],
            'rtl' => 'required'
        ];

        $validator = Validator::make($request->all(), $rules);
        if ($validator->fails()) {
            return Response::json([
                'errors' => $validator->getMessageBag()->toArray()
            ], 400);
        }
        $language->name = $request->name;
        $language->code = $request->code;
        $language->rtl = $request->rtl;
        $language->user_id = Auth::guard('web')->user()->id;
        $language->save();
        Session::flash('success', __('Updated Successfully'));
        return 'success';
    }

    public function editKeyword($id)
    {
       
        $la = Language::where('user_id', Auth::guard('web')->user()->id)->where('id', $id)->firstOrFail();
        $keywords = json_decode($la->keywords, true);
        
        return view('user.language.edit_keyword', compact('la', 'keywords'));
    }

    public function updateKeyword(Request $request, $id)
    {
        $lang = Language::query()->where('user_id', Auth::guard('web')->user()->id)->where('id', $id)->firstOrFail();
        $keywords = $request->except('_token');
        $lang->keywords = json_encode($keywords['keys']);
        $lang->save();

        Session::flash('success', __('Updated Successfully'));
        return 'success';
    }

    public function destroy($id)
    {
        $language = Language::where('user_id', Auth::guard('web')->user()->id)->findOrFail($id);

        if ($language->is_default == 1) {
            return back()->with('warning', __('Default language cannot be delete.'));
        } else {
            DB::transaction(function () use ($language) {
                DB::statement('SET FOREIGN_KEY_CHECKS=0');

                $BlogInformations = BlogInformation::where('language_id', $language->id);
                if ($BlogInformations->count() > 0) {
                    foreach ($BlogInformations->get() as $bc) {
                        // if this blog has no blog_contents of other languages except the selected one,
                        // then delete the blog...

                        $otherBcs = BlogInformation::where('language_id', '<>', $language->id)->where('blog_id', $bc->blog_id)->count();
                        if ($otherBcs == 0) {
                            $blog = Blog::findOrFail($bc->blog_id);
                            Uploader::remove(public_path(Constant::WEBSITE_BLOG_IMAGE), $blog->blog_img);
                            $blog->delete();
                        }


                        $bc->delete();
                    }
                }

                $bcats = BlogCategory::where('language_id', $language->id);
                if ($bcats->count() > 0) {
                    $bcats->delete();
                }

                $brands = Brand::where('language_id', $language->id);
                if ($brands->count() > 0) {
                    foreach ($brands as $brand) {
                        Uploader::remove(public_path(Constant::WEBSITE_BRAND_IMAGE), $brand->brand_img);
                        $brand->delete();
                    }
                }

                $basic_extendeds = BasicExtended::where('language_id', $language->id);
                if ($basic_extendeds->count() > 0) {
                    $basic_extendeds->delete();
                }

                $facilities = Facility::where('language_id', $language->id);
                if ($facilities->count() > 0) {
                    $facilities->delete();
                }

                $faqs = FAQ::where('language_id', $language->id);
                if ($faqs->count() > 0) {
                    $faqs->delete();
                }

                $fqls = FooterQuickLink::where('language_id', $language->id);
                if ($fqls->count() > 0) {
                    $fqls->delete();
                }

                $fts = FooterText::where('language_id', $language->id);
                if ($fts->count() > 0) {
                    $fts->delete();
                }

                $gcats = GalleryCategory::where('language_id', $language->id);
                if ($gcats->count() > 0) {
                    $gcats->delete();
                }

                $gals = Gallery::where('language_id', $language->id);
                if ($gals->count() > 0) {
                    foreach ($gals->get() as $gal) {
                        Uploader::remove(public_path(Constant::WEBSITE_GALLERY_IMAGE), $gal->gallery_img);
                        $gal->delete();
                    }
                }

                $sliders = HeroSlider::where('language_id', $language->id);
                if ($sliders->count() > 0) {
                    foreach ($sliders->get() as $slider) {
                        Uploader::remove(public_path(Constant::WEBSITE_HERO_SLIDER_IMAGE), $slider->img);
                        $slider->delete();
                    }
                }


                $counters = IntroCountInfo::where('language_id', $language->id);
                if ($counters->count() > 0) {
                    $counters->delete();
                }


                $menus = Menu::where('language_id', $language->id);
                if ($menus->count() > 0) {
                    $menus->delete();
                }

                $packageContents = PackageContent::where('language_id', $language->id);
                if ($packageContents->count() > 0) {
                    foreach ($packageContents->get() as $pc) {

                        // if this package has no package_contents of other languages except the selected one,
                        // then delete the package...
                        $otherPcs = PackageContent::where('language_id', '<>', $language->id)->where('package_id', $pc->package_id)->count();
                        if ($otherPcs == 0) {
                            $package = Package::findOrFail($pc->package_id);
                            Uploader::remove(public_path(Constant::WEBSITE_PACKAGE_IMAGE), $package->featured_img);

                            if (!empty($package->slider_imgs) && $package->slider_imgs != '[]') {
                                $sliders = json_decode($package->slider_imgs, true);
                                foreach ($sliders as $key => $slider) {
                                    Uploader::remove(public_path(Constant::WEBSITE_PACKAGE_SLIDER_IMAGE), $slider);
                                }
                            }

                            // delete package bookings
                            $pbookings = PackageBooking::where('package_id', $package->id);
                            if ($pbookings->count() > 0) {
                                foreach ($pbookings->get() as $key => $pb) {
                                    Uploader::remove(public_path(Constant::WEBSITE_PACKAGE_BOOKING_INVOICE), $pb->invoice);
                                    Uploader::remove(public_path(Constant::WEBSITE_PACKAGE_BOOKING_ATTACHMENTS), $pb->attachment);
                                    $pb->delete();
                                }
                            }

                            // delete package ratings
                            PackageReview::where('package_id', $package->id)->delete();

                            $package->delete();
                        }
                        $pc->delete();
                    }
                }


                PackagePlan::where('language_id', $language->id)->delete();
                PackageLocation::where('language_id', $language->id)->delete();
                PackageCategory::where('language_id', $language->id)->delete();

                $pcats = PackageCategory::where('language_id', $language->id);
                if ($pcats->count() > 0) {
                    $pcats->delete();
                }

                $pageContents = PageContent::where('language_id', $language->id);
                if ($pageContents->count() > 0) {
                    foreach ($pageContents->get() as $pc) {
                        // if this page has no page_contents of other languages except the selected one,
                        // then delete the page...

                        $otherPcs = PageContent::where('language_id', '<>', $language->id)->where('page_id', $pc->page_id)->count();
                        if ($otherPcs == 0) {
                            $page = Page::findOrFail($pc->page_id);
                            $page->delete();
                        }

                        $pc->delete();
                    }
                }

                PageHeading::where('language_id', $language->id)->delete();
                Popup::where('language_id', $language->id)->delete();

                $roomContents = RoomContent::where('language_id', $language->id);
                if ($roomContents->count() > 0) {
                    foreach ($roomContents->get() as $rc) {

                        // if this room has no room_contents of other languages except the selected one,
                        // then delete the room...
                        $otherRcs = RoomContent::where('language_id', '<>', $language->id)->where('room_id', $rc->room_id)->count();
                        if ($otherRcs == 0) {
                            $room = Room::findOrFail($rc->room_id);
                            Uploader::remove(public_path(Constant::WEBSITE_ROOM_IMAGE), $room->featured_img);
                            
                            if (!empty($room->slider_imgs) && $room->slider_imgs != '[]') {
                                $sliders = json_decode($room->slider_imgs, true);
                                foreach ($sliders as $key => $slider) {
                                    Uploader::remove(public_path(Constant::WEBSITE_ROOM_SLIDER_IMAGE), $slider);
                                }
                            }

                            // delete room bookings
                            $rbookings = RoomBooking::where('room_id', $room->id);
                            if ($rbookings->count() > 0) {
                                foreach ($rbookings->get() as $key => $rb) {
                                    Uploader::remove(public_path(Constant::WEBSITE_ROOM_BOOKING_INVOICE), $rb->invoice);
                                    Uploader::remove(public_path(Constant::WEBSITE_ROOM_BOOKING_ATTACHMENTS), $rb->attachment);
                                    $rb->delete();
                                }
                            }

                            // delete room ratings
                            RoomReview::where('room_id', $room->id)->delete();

                            $room->delete();
                        }
                        $rc->delete();
                    }
                }

                $rcats = RoomCategory::where('language_id', $language->id);
                if ($rcats->count() > 0) {
                    $rcats->delete();
                }

                $amms = RoomAmenity::where('language_id', $language->id);
                if ($amms->count() > 0) {
                    $amms->delete();
                }

                SectionHeading::where('language_id', $language->id)->delete();
                SEO::where('language_id', $language->id)->delete();

                $serviceContents = ServiceContent::where('language_id', $language->id);
                if ($serviceContents->count() > 0) {
                    foreach ($serviceContents->get() as $sc) {
                        // if this service has no service_contents of other languages except the selected one,
                        // then delete the service...

                        $otherScs = ServiceContent::where('language_id', '<>', $language->id)->where('service_id', $sc->service_id)->count();
                        if ($otherScs == 0) {
                            $service = Service::findOrFail($sc->service_id);
                            $service->delete();
                        }
                        $sc->delete();
                    }
                }

                BasicExtended::where('language_id',$language->id)->delete();
                Testimonial::where('language_id', $language->id)->delete();
            });

            // then, delete the info from db
            $language->delete();
            DB::statement('SET FOREIGN_KEY_CHECKS=1');
            return back()->with('success', __('Deleted Successfully'));
        }
    }

    public function rtlcheck($langid)
    {
        
        if ($langid > 0) {
            $lang = Language::where('user_id', Auth::guard('web')->user()->id)->find($langid);
        } else {
            return 0;
        }
        return $lang->rtl;
    }
}
