<?php

namespace App\Http\Controllers\User\HomePage;

use App\Constants\Constant;
use App\Http\Controllers\Controller;
use App\Http\Helpers\Uploader;
use App\Models\User\HomePage\Testimonial;
use App\Models\User\Language;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Mews\Purifier\Facades\Purifier;

class TestimonialController extends Controller
{

  public function testimonialSection(Request $request)
  {
    // first, get the language info from db
    $language = Language::where('code', $request->language)->where('user_id', Auth::guard('web')->user()->id)->firstorFail();
    $information['language'] = $language;
    // also, get the testimonials of that language from db
    $information['testimonialInfos'] = Testimonial::where('language_id', $language->id)
      ->orderby('id', 'desc')
      ->get();
    $information['langs'] = Language::where('user_id', Auth::guard('web')->user()->id)->get();

    return view('user.home_page.testimonial_section.index', $information);
  }

  public function createTestimonial(Request $request)
  {
    // first, get the language info from db
    $information['language'] = Language::where('code', $request->language)->where('user_id', Auth::guard('web')->user()->id)->first();
    return view('user.home_page.testimonial_section.create', $information);
  }

  public function storeTestimonial(Request $request, $language)
  {
    $rules = [
      'name' => 'required',
      'image' => 'required|image|mimes:jpeg,png,jpg|max:2048',
      'comment' => 'required',
      'designation' => 'required',
      'serial_number' => 'required'
    ];

    $validator = Validator::make($request->all(), $rules);
    if ($validator->fails()) {
      return redirect()->back()->withErrors($validator);
    }

    $lang = Language::where('code', $language)->where('user_id', Auth::guard('web')->user()->id)->first();
    $clientImgName = Uploader::upload_picture(public_path(Constant::WEBSITE_TESTIMONIAL_CLIENT_IMAGE), $request->file('image'));
    Testimonial::create($request->except('language_id', 'image') + [
      'language_id' => $lang->id,
      'name' => $request->name,
      'comment' => Purifier::clean($request->comment, 'youtube'),
      'designation' => $request->designation,
      'user_id' => Auth::guard('web')->user()->id,
      'image' => $request->hasFile('image') ? $clientImgName : NULL
    ]);

    Session::flash('success', __('Created Successfully'));
    return redirect()->back();
  }

  public function editTestimonial(Request $request, $id)
  {
    // first, get the language info from db
    $information['language'] = Language::where('code', $request->language)->first();
    $information['testimonialInfo'] = Testimonial::findOrFail($id);
    return view('user.home_page.testimonial_section.edit', $information);
  }

  public function updateTestimonial(Request $request, $id)
  {
    $rules = [
      'name' => 'required',
      'comment' => 'required',
      'designation' => 'required',
      'serial_number' => 'required'
    ];
    $validator = Validator::make($request->all(), $rules);
    if ($validator->fails()) {
      return redirect()->back()->withErrors($validator);
    }
    $testimonial = Testimonial::findOrFail($id);
    if ($request->hasFile('image')) {
      // second, set a name for the image and store it to local storage
      $clientImgName = Uploader::update_picture(public_path(Constant::WEBSITE_TESTIMONIAL_CLIENT_IMAGE ),$request->file('image'), $testimonial->image);
    }
    $testimonial->update($request->except('image', 'comment') + [
      'image' => $request->hasFile('image') ? $clientImgName : $testimonial->image,
      'comment' => Purifier::clean($request->comment, 'youtube'),
    ]);

    Session::flash('success', __('Updated Successfully'));
    return redirect()->back();
  }

  public function deleteTestimonial(Request $request)
  {
    $testimonial = Testimonial::findOrFail($request->testimonial_id);
    Uploader::remove(public_path(Constant::WEBSITE_TESTIMONIAL_CLIENT_IMAGE) , $testimonial->image);
    $testimonial->delete();

    Session::flash('success', __('Deleted Successfully'));
    return redirect()->back();
  }
}
