<?php
namespace App\Http\Controllers\User\HomePage;


use App\Http\Controllers\Controller;
use App\Models\User\BasicSetting;
use App\Models\User\Language;
use App\Models\User\Section;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;

class SectionsController extends Controller
{
    public function sections(Request $request)
    {
        $userBs           = BasicSetting::where('user_id', Auth::guard('web')->user()->id)->first();
        $language = Language::where('is_default', 1)->where('user_id', Auth::guard('web')->user()->id)->first();
        $sections = Section::where('user_id', Auth::guard('web')->user()->id)->firstOrFail();;

        if (!is_null($sections->additional_section_status) && $sections->additional_section_status != "null") {
            $data['additional_section_statuses'] = json_decode($sections->additional_section_status, true);
        } else {
            $data['additional_section_statuses'] = [];
        }
        $data['languge_id'] = $language->id;
        $data['sections'] = $sections;

        return view('user.home_page.sections', $data);
    }

    public function updatesections(Request $request)
    {
       
        $settings                            = BasicSetting::where('user_id', Auth::guard('web')->user()->id)->first();
        $sections                            = Section::where('user_id', Auth::guard('web')->user()->id)->firstOrFail();
        
        $sections->search_section            = $request->has('search_section') ?  $request->search_section : optional($sections)->search_section;
        $sections->intro_section             = $request->has('intro_section') ?  $request->intro_section : optional($sections)->intro_section;
        $sections->featured_rooms_section    = $request->has('featured_rooms_section') ?  $request->featured_rooms_section : optional($sections)->featured_rooms_section;
        $sections->featured_services_section = $request->has('featured_services_section') ?  $request->featured_services_section : optional($sections)->featured_services_section;
        $sections->faq_section               = $request->has('faq_section') ?  $request->faq_section : optional($sections)->faq_section;
        $sections->blogs_section             = $request->has('blogs_section') ?  $request->blogs_section : optional($sections)->blogs_section;
        $sections->facilities_section        = $request->has('facilities_section') ?  $request->facilities_section : optional($sections)->facilities_section;
        $sections->statistics_section        = $request->has('statistics_section') ?  $request->statistics_section : optional($sections)->statistics_section;
        $sections->video_section             = $request->has('video_section') ?  $request->video_section : optional($sections)->video_section;
        $sections->featured_package_section  = $request->has('featured_package_section') ?  $request->featured_package_section : optional($sections)->featured_package_section;
        $sections->testimonials_section     = $request->has('testimonials_section') ?  $request->testimonials_section : optional($sections)->testimonials_section;
        $sections->brand_section            = $request->has('brand_section') ?  $request->brand_section : optional($sections)->brand_section;
        $sections->top_footer_section       = $request->has('top_footer_section') ?  $request->top_footer_section : optional($sections)->top_footer_section;
        $sections->copyright_section        = $request->has('copyright_section') ?  $request->copyright_section : optional($sections)->copyright_section;
        $sections->featured_rooms_category_section        = $request->has('featured_rooms_category_section') ?  $request->featured_rooms_category_section : optional($sections)->featured_rooms_category_section;

        $sections->additional_section_status = $request->has('additional_sections') ?  json_encode($request->additional_sections, true) :  optional($sections)->additional_sections ;
       
        $sections->latest_packages_section        = $request->has('latest_packages_section') ?  $request->latest_packages_section : optional($sections)->latest_packages_section;
        
        $sections->latest_rooms_section        = $request->has('latest_rooms_section') ?  $request->latest_rooms_section : optional($sections)->latest_rooms_section;
        $sections->package_category_section        = $request->has('package_category_section') ?  $request->package_category_section : optional($sections)->package_category_section;
        
        $sections->save();

        Session::flash('success', __('Updated Successfully'));
        return back();
    }
}
