<?php

namespace App\Http\Controllers\User\HomePage;

use App\Http\Controllers\Controller;
use App\Http\Requests\CounterInfoRequest;
use App\Models\User\HomePage\IntroCountInfo;
use App\Models\User\Language;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;

class IntroSectionController extends Controller
{
  public function introSection(Request $request)
  {
    // first, get the language info from db
    $language = Language::where('code', $request->language)->where('user_id', Auth::guard('web')->user()->id)->firstorFail();
    $information['language'] = $language;
    // also, get the features of that language from db
    $information['counterInfos'] = IntroCountInfo::where('language_id', $language->id)->where('user_id', Auth::guard('web')->user()->id)
      ->orderBy('id', 'desc')
      ->get();
    // get all the languages from db
    $information['langs'] = Language::where('user_id', Auth::guard('web')->user()->id)->get();

    return view('user.home_page.intro_section.index', $information);
  }


  public function createCountInfo(Request $request)
  {
    // first, get the language info from db
    $information['language'] = Language::where('code', $request->language)->where('user_id', Auth::guard('web')->user()->id)->first();

    return view('user.home_page.intro_section.create', $information);
  }

  public function storeCountInfo(CounterInfoRequest $request, $language)
  {
    $lang = Language::where('code', $language)->where('user_id', Auth::guard('web')->user()->id)->first();

    IntroCountInfo::create($request->except('language_id') + [
      'language_id' => $lang->id,
      'user_id' => Auth::guard('web')->user()->id,
    ]);

    Session::flash('success', __('Created Successfully'));
    return 'success';
  }

  public function editCountInfo(Request $request, $id)
  {
    // first, get the language info from db
    $information['language'] = Language::where('code', $request->language)->first();
    $information['counterInfo'] = IntroCountInfo::findOrFail($id);

    return view('user.home_page.intro_section.edit', $information);
  }

  public function updateCountInfo(CounterInfoRequest $request, $id)
  {
    IntroCountInfo::find($id)->update($request->all());
    Session::flash('success', __('Updated Successfully'));
    return 'success';
  }

  public function deleteCountInfo(Request $request)
  {
    IntroCountInfo::find($request->counterInfo_id)->delete();
    Session::flash('success', __('Deleted Successfully'));
    return redirect()->back();
  }
}
