<?php

namespace App\Http\Controllers\User\HomePage;

use App\Constants\Constant;
use App\Http\Controllers\Controller;
use App\Http\Helpers\Uploader;
use App\Http\Requests\HeroSliderRequest;
use App\Models\User\HomePage\HeroSlider;
use App\Models\User\Language;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;

class HeroSliderController extends Controller
{
  public function sliderVersion(Request $request)
  {
    // first, get the language info from db
    $language = Language::where('code', $request->language)->where('user_id', Auth::guard('web')->user()->id)->firstorFail();
    $information['language'] = $language;

    // then, get the slider version info of that language from db
    $information['sliders'] = HeroSlider::where('language_id', $language->id)->where('user_id', Auth::guard('web')->user()->id)
      ->orderBy('id', 'desc')
      ->get();

    // get all the languages from db
    $information['langs'] = Language::where('user_id', Auth::guard('web')->user()->id)->get();

    return view('user.home_page.hero_section.slider_version', $information);
  }

  public function createSlider(Request $request)
  {
    // get the language info from db
    $language = Language::where('code', $request->language)->firstOrFail();
    $information['language'] = $language;

    return view('user.home_page.hero_section.create_slider', $information);
  }

  public function storeSliderInfo(HeroSliderRequest $request, $language)
  {
    $lang = Language::where('code', $language)->where('user_id', Auth::guard('web')->user()->id)->first();
    // set a name for the image and store it to local storage
    $imgName = Uploader::upload_picture(public_path(Constant::WEBSITE_HERO_SLIDER_IMAGE), $request->file('img'));
    HeroSlider::create($request->except('language_id', 'img') + [
      'language_id' => $lang->id,
      'user_id' => Auth::guard('web')->user()->id,
      'img' => $imgName
    ]);
    Session::flash('success', __('Created Successfully'));
    return redirect()->back();
  }

  public function editSlider(Request $request, $id)
  {
    // get the language info from db
    $language = Language::where('code', $request->language)->where('user_id', Auth::guard('web')->user()->id)->firstorFail();
    $information['language'] = $language;
    // get the slider info from db for update
    $information['slider'] = HeroSlider::findOrFail($id);

    return view('user.home_page.hero_section.edit_slider', $information);
  }

  public function updateSliderInfo(Request $request, $id)
  {
    $slider = HeroSlider::findOrFail($id);

    if ($request->hasFile('img')) {
      $imgName = Uploader::update_picture(public_path(Constant::WEBSITE_HERO_SLIDER_IMAGE), $request->file('img'), $slider->img);
    }
    $slider->update($request->except('img') + [
      'img' => $request->hasFile('img') ? $imgName : $slider->img
    ]);
    Session::flash('success', __('Updated Successfully'));
    return redirect()->back();
  }

  public function deleteSlider(Request $request)
  {
    $slider = HeroSlider::findOrFail($request->slider_id);
    Uploader::remove(public_path(Constant::WEBSITE_HERO_SLIDER_IMAGE), $slider->img);
    $slider->delete();

    Session::flash('success', __('Deleted Successfully'));
    return redirect()->back();
  }
}
