<?php

namespace App\Http\Controllers\User\HomePage;

use App\Http\Controllers\Controller;
use App\Models\User\HomePage\Facility;
use App\Models\User\Language;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;

class FacilityController extends Controller
{

  public function facilitySection(Request $request)
  {
    // first, get the language info from db
    $language = Language::where('code', $request->language)->where('user_id', Auth::guard('web')->user()->id)->firstorFail();
    $information['language'] = $language;
    // also, get the facilities of that language from db
    $information['facilityInfos'] = Facility::where('language_id', $language->id)->where('user_id', Auth::guard('web')->user()->id)
      ->orderby('id', 'desc')
      ->get();
    // get all the languages from db
    $information['langs'] = Language::where('user_id', Auth::guard('web')->user()->id)->get();

    return view('user.home_page.facility_section.index', $information);
  }
  public function createFacility(Request $request)
  {
    // first, get the language info from db
    $information['language'] = Language::where('code', $request->language)->where('user_id', Auth::guard('web')->user()->id)->first();
    return view('user.home_page.facility_section.create', $information);
  }

  public function storeFacility(Request $request, $language)
  {
    $rules = [
      'facility_icon' => 'required',
      'facility_title' => 'required',
      'facility_text' => 'required'
    ];

    $validator = Validator::make($request->all(), $rules);
    if ($validator->fails()) {
      return Response::json([
        'errors' => $validator->getMessageBag()->toArray()
      ], 400);
    }

    $lang = Language::where('code', $language)->where('user_id', Auth::guard('web')->user()->id)->first();
    Facility::create($request->except('language_id') + [
      'language_id' => $lang->id,
      'user_id' => Auth::guard('web')->user()->id,
    ]);

    Session::flash('success', __('Created Successfully'));
    return 'success';
  }

  public function editFacility(Request $request, $id)
  {
    // first, get the language info from db
    $information['language'] = Language::where('code', $request->language)->where('user_id', Auth::guard('web')->user()->id)->first();
    $information['facilityInfo'] = Facility::findOrFail($id);

    return view('user.home_page.facility_section.edit', $information);
  }

  public function updateFacility(Request $request, $id)
  {
    $rules = [
      'facility_icon' => 'required',
      'facility_title' => 'required',
      'facility_text' => 'required'
    ];

    $validator = Validator::make($request->all(), $rules);
    if ($validator->fails()) {
      return Response::json([
        'errors' => $validator->getMessageBag()->toArray()
      ], 400);
    }
    Facility::find($id)->update($request->all());

    Session::flash('success', __('Updated Successfully'));
    return 'success';
  }

  public function deleteFacility(Request $request)
  {
    Facility::find($request->facilityInfo_id)->delete();
    Session::flash('success', __('Deleted Successfully'));
    return redirect()->back();
  }
}
