<?php

namespace App\Http\Controllers\User;

use App\Constants\Constant;
use App\Enums\ThemeVersion;
use App\Http\Controllers\Controller;
use App\Http\Helpers\Uploader;
use App\Models\User\BasicSetting;
use App\Models\User\FooterQuickLink;
use App\Models\User\FooterText;
use App\Models\User\Language;
use App\Rules\ImageMimeTypeRule;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;

class FooterController extends Controller
{
    public function footerContent(Request $request)
    {
        // first, get the language info from db
        $lang = Language::where('user_id', Auth::guard('web')->user()->id)
            ->where('code', $request->language)
            ->firstorFail();
        $information['themeInfo'] = BasicSetting::where('user_id', Auth::guard('web')->user()->id)
            ->select('theme_version','footer_logo', 'footer_bg_image')
            ->firstorFail();
        // then, get the footer text info of that language from db
        $information['data'] = FooterText::where('language_id', $lang->id)
            ->where('user_id', Auth::guard('web')->user()->id)
            ->firstorFail();
        return view('user.footer.text', $information);
    }

    public function updateFooterContent(Request $request, $language)
    {
      $userBs =  BasicSetting::where('user_id', Auth::guard('web')->user()->id)
            ->select('theme_version', 'footer_logo','footer_bg_image')
            ->first();
        $rules = [
            'footer_logo' => [is_null($userBs->footer_logo) ? 'required':'nullable' , new ImageMimeTypeRule()],
            'copyright_text' => 'required',
            'copyright_text' => 'required',
        ];
        $message = [
            'about_company.required' => __('The about company field is required'),
            'copyright_text.required' => __('The copy right text field is required'),
        ];
        $validator = Validator::make($request->all(), $rules, $message);

        if (in_array($userBs->theme_version, [ThemeVersion::ThemeThree->value, ThemeVersion::ThemeFour->value, ThemeVersion::ThemeFive->value])) {
            $rules['footer_bg_image'] = [
                'nullable',
                new ImageMimeTypeRule()
            ];
        }
        if ($validator->fails()) {
            return Response::json(
                [
                    'errors' => $validator->getMessageBag()->toArray()
                ],
                400
            );
        }

        if ($request->hasFile('footer_bg_image')) {
            $footer_bg_image = Uploader::upload_picture(public_path(Constant::WEBSITE_FOOTER_LOGO),$request->file('footer_bg_image'));
            BasicSetting::query()->updateOrInsert(
                ['user_id' => Auth::guard('web')->user()->id],
                ['footer_bg_image' => $footer_bg_image]
            );
            
        }

        if ($request->hasFile('footer_logo')) {
            $filename = Uploader::upload_picture(public_path(Constant::WEBSITE_FOOTER_LOGO), $request->file('footer_logo'));
            BasicSetting::query()->updateOrInsert(
                ['user_id' => Auth::guard('web')->user()->id],
                ['footer_logo' => $filename]
            );
        }

        $lang = Language::where('code', $language)->where('user_id', Auth::guard('web')->user()->id)->first();
        FooterText::query()->updateOrInsert(
            [
                'user_id' => Auth::guard('web')->user()->id,
                'language_id' => $lang->id
            ],
            [
                'language_id' => $lang->id,
                'copyright_text' => $request->copyright_text,
                'about_company' => $request->about_company,
                'user_id' => Auth::guard('web')->user()->id
            ]
        );
        Session::flash('success', __('Updated Successfully'));
        return 'success';
    }


    public function quickLinks(Request $request)
    {
        // first, get the language info from db
        $language = Language::where('code', $request->language)
            ->where('user_id', Auth::guard('web')->user()->id)
            ->firstOrFail();

        // then, get the footer quick link info of that language from db
        $information['links'] = FooterQuickLink::where('language_id', $language->id)
            ->where('user_id', Auth::guard('web')->user()->id)
            ->orderBy('id', 'desc')
            ->get();

        $information['userLanguages'] = Language::where('user_id', Auth::guard('web')->user()->id)->get();
        return view('user.footer.quick_links', $information);
    }

    public function storeQuickLink(Request $request)
    {
        $rules = [
            'title' => 'required',
            'url' => 'required',
            'serial_number' => 'required',
            'user_language_id' => 'required',
        ];
        $message = [
            'user_language_id.required' => __('The language field is required'),
        ];

        $validator = Validator::make($request->all(), $rules, $message);

        if ($validator->fails()) {
            return Response::json([
                'errors' => $validator->getMessageBag()->toArray()
            ], 400);
        }
        FooterQuickLink::create($request->except('language_id', 'user_id') + [
            'language_id' => $request->user_language_id,
            'user_id' => Auth::guard('web')->user()->id,
        ]);
        Session::flash('success', __('Created Successfully'));
        return 'success';
    }

    public function updateQuickLink(Request $request)
    {
        $rules = [
            'title' => 'required',
            'url' => 'required',
            'serial_number' => 'required'
        ];
        $validator = Validator::make($request->all(), $rules);

        if ($validator->fails()) {
            return Response::json([
                'errors' => $validator->getMessageBag()->toArray()
            ], 400);
        }
        FooterQuickLink::where('user_id', Auth::user()->id)
            ->where('id', $request->link_id)
            ->firstOrFail()
            ->update($request->all());
        Session::flash('success', __('Updated Successfully'));
        return 'success';
    }

    public function deleteQuickLink(Request $request)
    {
        FooterQuickLink::where('user_id', Auth::user()->id)->where('id', $request->link_id)->firstOrFail()->delete();
        Session::flash('success', __('Deleted Successfully'));
        return redirect()->back();
    }
}
