<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use App\Models\User\FAQ;
use App\Models\User\HomePage\SectionHeading;
use App\Models\User\Language;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;

class FaqController extends Controller
{
    public function index(Request $request)
    {
        $information['langs'] = Language::query()->where('user_id', Auth::guard('web')->user()->id)->get();
        $information['language'] = Language::where('code', $request->language)->where('user_id', Auth::guard('web')->user()->id)->firstOrFail();

        // then, get the faqs of that language from db
        $information['faqs'] = FAQ::where('language_id', $information['language']->id)
            ->where('user_id', Auth::guard('web')->user()->id)
            ->orderByDesc('id')
            ->get();

        return view('user.faq.index', $information);
    }

    public function store(Request $request, $language)
    {
        $rules = [
            'question' => 'required',
            'answer' => 'required',
            'serial_number' => 'required'
        ];
        $validator = Validator::make($request->all(), $rules);
        if ($validator->fails()) {
            return Response::json([
                'errors' => $validator->getMessageBag()->toArray()
            ], 400);
        }
        $lang = Language::where('code', $language)->where('user_id', Auth::guard('web')->user()->id)->firstOrFail();
        FAQ::create($request->except('user_id') + [
            'language_id' => $lang->id,
            'user_id' => Auth::guard('web')->user()->id
        ]);

        Session::flash('success', __('Created Successfully'));
        return "success";
    }

    public function update(Request $request)
    {
        $rules = [
            'question' => 'required',
            'answer' => 'required',
            'serial_number' => 'required'
        ];
        $validator = Validator::make($request->all(), $rules);
        if ($validator->fails()) {
            return Response::json([
                'errors' => $validator->getMessageBag()->toArray()
            ], 400);
        }
        FAQ::where('user_id', Auth::guard('web')->user()->id)->find($request->id)->update($request->all());
        Session::flash('success', __('Updated Successfully'));
        return "success";
    }

    public function destroy($id)
    {
        FAQ::where('user_id', Auth::guard('web')->user()->id)->find($id)->delete();
        return redirect()->back()->with('success', __('Deleted Successfully'));
    }

    public function bulkDestroy(Request $request)
    {
        $ids = $request->ids;
        foreach ($ids as $id) {
            FAQ::where('user_id', Auth::guard('web')->user()->id)->find($id)->delete();
        }
        Session::flash('success', __('Deleted Successfully'));
        return "success";
    }
}
