<?php
namespace App\Http\Controllers\User;

use App\Enums\ThemeVersion;
use App\Http\Controllers\Controller;
use App\Models\User\AdditionalSection;
use App\Models\User\AdditionalSectionContent;
use App\Models\User\BasicSetting;
use App\Models\User\Language;
use App\Models\User\Section;
use App\Traits\CustomSection;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Mews\Purifier\Facades\Purifier;

class AdditionalSectionController extends Controller
{
    public function index(Request $request)
    {
        $lang    = Language::where([['code', $request->language], ['user_id', Auth::guard('web')->user()->id]])->firstorFail();
        $information['langs']    = Language::where('user_id', Auth::guard('web')->user()->id)->get();
        $information['sections'] = AdditionalSection::join('user_additional_section_contents', 'user_additional_section_contents.addition_section_id', '=', 'user_additional_sections.id')
            ->where('user_additional_section_contents.language_id', $lang->id)
            ->where('user_additional_sections.page_type', 'home')
            ->select('user_additional_sections.*', 'user_additional_section_contents.section_name')
            ->get();
        return view('user.home_page.additional-section.index', $information);
    }

    public function create(Request $request)
    {
        $settings                 = BasicSetting::query()->where('user_id', Auth::guard('web')->user()->id)->select('theme_version')->first();
        $information['language']  = Language::where([['is_default', 1], ['user_id', Auth::guard('web')->user()->id]])->first();
        $information['languages'] = Language::where('user_id', Auth::guard('web')->user()->id)->get();
        $information['page_type'] = 'home';

        if ($settings->theme_version == ThemeVersion::ThemeOne->value) {
            $information['all_sections'] = CustomSection::TenantFrontThemeOne(Auth::guard('web')->user()->id);
        }
        if ($settings->theme_version == ThemeVersion::ThemeTwo->value) {
            $information['all_sections'] = CustomSection::TenantFrontThemeTwo(Auth::guard('web')->user()->id);
        }
        if ($settings->theme_version == ThemeVersion::ThemeThree->value) {
            $information['all_sections'] = CustomSection::TenantFrontThemeThree(Auth::guard('web')->user()->id);
        }
        if ($settings->theme_version == ThemeVersion::ThemeFour->value) {
            $information['all_sections'] = CustomSection::TenantFrontThemeFour(Auth::guard('web')->user()->id);
        }
        if ($settings->theme_version == ThemeVersion::ThemeFive->value) {
            $information['all_sections'] = CustomSection::TenantFrontThemeFive(Auth::guard('web')->user()->id);
        }

        return view('user.home_page.additional-section.create', $information);
    }

    public function store(Request $request)
    {
        $rules = [
            'possition'     => 'required',
            'page_type'     => 'required',
            'serial_number' => 'required',
        ];
        $languages = Language::where('user_id', Auth::guard('web')->user()->id)->get();
        $messages  = [];
        
        $defaulLang = Language::where([['user_id', Auth::guard('web')->user()->id], ['is_default', 1]])->first();
        $rules[$defaulLang->code . '_section_name'] = 'required';
        $rules[$defaulLang->code . '_content'] = 'required';
        
        foreach ($languages as $language) {
            if ($request->input($language->code . '_section_name') ||  $request->input($language->code . '_content')) {
                $rules[$language->code . '_section_name'] = 'required';
                $rules[$language->code . '_content'] = 'required';
            }
            $messages[$language->code . '_section_name.required'] = __('The section title is required for') . ' ' . $language->name . ' ' . __('language').'.';
            $messages[$language->code . '_content.required']  =  __('The section content is required for') . ' ' . $language->name .  ' ' . __('language'). '.';
        }

        $validator = Validator::make($request->all(), $rules, $messages);
        if ($validator->fails()) {
            return response()->json([
                'errors' => $validator->getMessageBag(),
            ], 400);
        }

        $languages     = Language::where('user_id', Auth::guard('web')->user()->id)->get();
        $in            = $request->all();
        $in['user_id'] = Auth::guard('web')->user()->id;
        $section       = AdditionalSection::create($in);

        foreach ($languages as $language) {
            $code = $language->code;
            if ($request->input($language->code . '_section_name') ||  $request->input($language->code . '_content')) {
                $content                      = new AdditionalSectionContent();
                $content->language_id         = $language->id;
                $content->addition_section_id = $section->id;
                $content->section_name        = $request[$code . '_section_name'];
                $content->content             = Purifier::clean($request[$code . '_content'], 'youtube');
                $content->save();
            }
        }

        $sections = Section::where('user_id', Auth::guard('web')->user()->id)->first();
        $arr                 = json_decode($sections->additional_section_status, true);
        $arr["$section->id"] = "1";
        $sections->additional_section_status = json_encode($arr);
        $sections->save();

        Session::flash('success', __('Added Successfully'));
        return 'success';
    }

    public function edit($id, Request $request)
    {
        $settings = BasicSetting::query()->where('user_id', Auth::guard('web')->user()->id)->select('theme_version')->first();
        

        $information['languages'] = Language::where('user_id', Auth::guard('web')->user()->id)->get();
        $information['language']  = Language::where('is_default', 1)->where('user_id', Auth::guard('web')->user()->id)->first();
        $information['section']   = AdditionalSection::where([['page_type', 'home'], ['user_id', Auth::guard('web')->user()->id], ['id', $id]])->firstOrFail();

        if ($settings->theme_version == ThemeVersion::ThemeOne->value) {
            $information['all_sections'] = CustomSection::TenantFrontThemeOne(Auth::guard('web')->user()->id);
        }
        if ($settings->theme_version == ThemeVersion::ThemeTwo->value) {
            $information['all_sections'] = CustomSection::TenantFrontThemeTwo(Auth::guard('web')->user()->id);
        }
        if ($settings->theme_version == ThemeVersion::ThemeThree->value) {
         
            $information['all_sections'] = CustomSection::TenantFrontThemeThree(Auth::guard('web')->user()->id);
        }
        if ($settings->theme_version == ThemeVersion::ThemeFour->value) {
            $information['all_sections'] = CustomSection::TenantFrontThemeFour(Auth::guard('web')->user()->id);
        }
        if ($settings->theme_version == ThemeVersion::ThemeFive->value) {
            $information['all_sections'] = CustomSection::TenantFrontThemeFive(Auth::guard('web')->user()->id);
        }

        return view('user.home_page.additional-section.edit', $information);
    }

    public function update(Request $request, $id)
    {
        $rules = [
            'possition'     => 'required',
            'page_type'     => 'required',
            'serial_number' => 'required',
        ];
        $languages = Language::where('user_id', Auth::guard('web')->user()->id)->get();
        $defaulLang = Language::where([['user_id', Auth::guard('web')->user()->id], ['is_default', 1]])->first();
        $messages  = [];
  
        $rules[$defaulLang->code . '_section_name'] = 'required|max:255';
        $rules[$defaulLang->code . '_content'] = 'required';
        
        foreach ($languages as $language) {
            $hasExistingContent = AdditionalSectionContent::where('addition_section_id', $id)
                ->where('language_id', $language->id)
                ->exists();
               
            if ($hasExistingContent ||
                $request->input($language->code . '_section_name') ||
                $request->input($language->code . '_content') 
            ){
               
                $rules[$language->code . '_section_name'] = 'required';
                $rules[$language->code . '_content'] = 'required';
            }
            
            $messages[$language->code . '_section_name.required'] = __('The section title is required for') . $language->name . ' '. __('language') .'.';
            
            $messages[$language->code . '_content.required'] = __('The section content is required for') . $language->name . ' '  . __('language') . '.';
            
        }

        $validator = Validator::make($request->all(), $rules, $messages);
        if ($validator->fails()) {
            return response()->json([
                'errors' => $validator->getMessageBag(),
            ], 400);
        }

        $section = AdditionalSection::where([
            ['id', $id],
            ['user_id', Auth::guard('web')->user()->id],
        ])->first();
        $section->possition     = $request->possition;
        $section->page_type     = $request->page_type;
        $section->serial_number = $request->serial_number;
        $section->save();

        foreach ($languages as $language) {
            $hasExistingContent = AdditionalSectionContent::where('addition_section_id', $id)
                ->where('language_id', $language->id)
                ->exists();
            $content = AdditionalSectionContent::where('addition_section_id', $id)->where('language_id', $language->id)->first();
            if (empty($content)) {
                $content = new AdditionalSectionContent();
            }
            $code = $language->code;
            if ($hasExistingContent || $request->filled($code . '_section_name') || $request->filled($code . '_content')) {
                // Retrieve the content for the given section and language, or create a new one if it doesn't exist
                $content = AdditionalSectionContent::firstOrNew([
                    'addition_section_id' => $section->id,
                    'language_id'         => $language->id,
                ]);
                $content->section_name = $request[$code . '_section_name'];
                $content->content      = Purifier::clean($request[$code . '_content'], 'youtube');
                $content->save();
            }
        }

        Session::flash('success', 'Section updated successfully!');

        return 'success';
    }

    public function delete($id)
    {
        $section  = AdditionalSection::where([['id', $id], ['user_id', Auth::guard('web')->user()->id]])->first();
        $contents = AdditionalSectionContent::where('addition_section_id', $id)->get();
        foreach ($contents as $content) {
            $content->delete();
        }
        $section->delete();
        return redirect()->back()->with('success', 'Section delete successfully!');
    }

    public function bulkdelete(Request $request)
    {
        $ids = $request->ids;
        foreach ($ids as $id) {
            $section = AdditionalSection::where([['id', $id], ['user_id', Auth::guard('web')->user()->id]])->first();

            $contents = AdditionalSectionContent::where('addition_section_id', $id)->get();

            foreach ($contents as $pageContent) {
                $pageContent->delete();
            }

            $section->delete();
        }
        Session::flash('success', 'Sections deleted successfully!');
        return "success";
    }
}
