<?php
namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use App\Models\User\Language;
use App\Models\User\Section;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;

class AboutUsController extends Controller
{
    public function sections()
    {
        $data['ubs'] = Section::where('user_id', Auth::guard('web')->user()->id)->firstOrFail();
        if (! is_null($data['ubs']->about_additional_section_status) && $data['ubs']->about_additional_section_status != "null") {
            $data['additional_section_statuses'] = json_decode($data['ubs']->about_additional_section_status, true);
        } else {
            $data['additional_section_statuses'] = [];
        }
        $data['langid'] = Language::where([['is_default', 1], ['user_id', Auth::guard('web')->user()->id]])->first()->id;

        return view('user.about.sections', $data);
    }

    public function updatesections(Request $request)
    {
        $section = Section::where('user_id', Auth::guard('web')->user()->id)->firstOrFail();
        $section->about_info_section              = $request->about_info_section;
        $section->about_facility_section          = $request->about_facility_section;
        $section->about_testimonial_section       = $request->about_testimonial_section;
        $section->about_additional_section_status = json_encode($request->additional_sections, true);
        $section->save();

        Session::flash('success', __('Updated Successfully'));
        return back();
    }

}
