<?php

namespace App\Http\Controllers\User;

use App\Constants\Constant;
use App\Http\Controllers\Controller;
use App\Http\Helpers\Uploader;
use App\Models\User\HomePage\SectionHeading;
use App\Models\User\Language;
use App\Rules\ImageMimeTypeRule;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Mews\Purifier\Facades\Purifier;

class AboutPageController extends Controller
{
    public function index(Request $request)
    {
        $language = Language::where('code', $request->language)->where('user_id', Auth::guard('web')->user()->id)->firstOrFail();
        $data['language'] = $language;
        $data['data'] = SectionHeading::firstOrCreate(
            ['user_id' => Auth::guard('web')->user()->id, 'language_id' => $language->id]
        );
        return view('user.settings.about_page_images_texts', $data);
    }
    public function update(Request $request)
    {
        $languageId = $request->language_id;
        $secHeading = SectionHeading::query()
            ->where('user_id', Auth::guard('web')->user()->id)
            ->where('language_id', $languageId)
            ->first();
            
        $rules = [

            'facility_section_title' => 'required|max:255',

            'testimonial_section_title' => 'required|max:255',
            'testimonial_section_text' => 'nullable',

            'about_section_title' => 'nullable|max:255',
            'about_section_text' => 'nullable',

            'about_section_image' => [is_null($secHeading->about_page_about_section_image) ? 'required' : 'nullable', new ImageMimeTypeRule()],
            'facility_section_image' => [is_null($secHeading->about_page_facility_section_image) ? 'required' : 'nullable', new ImageMimeTypeRule()],

        ];

        $messages = [];

        $validator = Validator::make($request->all(), $rules, $messages);
        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422);
        }

        $about_section_image = $secHeading->about_page_about_section_image;
        if ($request->hasFile('about_section_image')) {
            $about_section_image = Uploader::update_picture(
                public_path(Constant::WEBSITE_ABOUT_US_SECTION_IMAGE), $request->file('about_section_image'), $secHeading->about_page_about_section_image);
        }

        $facility_section_image = $secHeading->about_page_facility_section_image;
        if ($request->hasFile('facility_section_image')) {
            $facility_section_image = Uploader::update_picture(
                public_path(Constant::WEBSITE_FACILITY_SECTION_IMAGE), $request->file('facility_section_image'), $secHeading->about_page_facility_section_image);
        }

        SectionHeading::query()->updateOrInsert(
            ['user_id' => Auth::guard('web')->user()->id, 'language_id' => $languageId],
            [
                'about_page_facility_section_title' => $request->facility_section_title,
                
                
                'about_page_testimonial_section_title' => $request->testimonial_section_title,
                'about_page_testimonial_section_text' => Purifier::clean($request->testimonial_section_text, 'youtube'),
                
                'about_page_about_section_title' => $request->about_section_title,
                'about_page_about_section_text' => Purifier::clean($request->about_section_text, 'youtube'),
                
                'about_page_facility_section_image' => $facility_section_image,
                'about_page_about_section_image' => $about_section_image,
            ]
        );

        Session::flash('success', __('Updated Successfully'));
        return "success";
        
    }
}
