<?php

namespace App\Http\Controllers\FrontEnd;

use App\Enums\ThemeVersion;
use App\Http\Controllers\Controller;
use App\Http\Helpers\MegaMailer;
use App\Http\Helpers\UserPermissionHelper;
use App\Models\User\AdditionalSection;
use App\Models\User\BasicSetting;
use App\Models\User\CustomPage\Page;
use App\Models\User\FAQ;
use App\Models\User\HomePage\Brand;
use App\Models\User\HomePage\Facility;
use App\Models\User\HomePage\HeroSlider;
use App\Models\User\HomePage\IntroCountInfo;
use App\Models\User\HomePage\SectionHeading;
use App\Models\User\HomePage\Testimonial;
use App\Models\User\Journal\BlogInformation;
use App\Models\User\Language;
use App\Models\User\Package;
use App\Models\User\PackageCategory;
use App\Models\User\PackageContent;
use App\Models\User\PackageLocation;
use App\Models\User\Room;
use App\Models\User\RoomCategory;
use App\Models\User\RoomContent;
use App\Models\User\ServiceContent;
use App\Traits\CustomSection;
use App\Traits\MiscellaneousTrait;
use Illuminate\Support\Facades\Session;
use Illuminate\Http\Request;

class UserViewController extends Controller
{
    public function userDetailView($domain)
    {
        $user                   = getUser();
        $language = MiscellaneousTrait::getLanguage();
        $packageFeatures =  UserPermissionHelper::currentPackageFeatures($user->id);

        $queryResult['seo'] = $this->getUserSeoData($language, $user->id);
        $queryResult['numOfBed']     = Room::where('status', 1)->max('bed');
        $queryResult['numOfBath']    = Room::where('status', 1)->max('bath');
        $queryResult['numOfGuest']   = Room::where('status', 1)->max('max_guests');
        $queryResult['counterInfos'] = IntroCountInfo::where('language_id', $language->id)->where('user_id', $user->id)->orderBy('serial_number', 'asc')->get();
        $queryResult['secHeading'] = SectionHeading::where('language_id', $language->id)->where('user_id', $user->id)->first();
        
        $queryResult['roomInfos']  = RoomContent::with('room')
            ->whereHas('room', function ($query) {
                $query->where('status', 1)
                    ->where('is_featured', 1);
            })
            ->where('language_id', $language->id)
            ->where('user_id', $user->id)
            ->get()
            ->map(function ($roomContent) use ($language) {
                $roomCategory = RoomCategory::where('indx', optional($roomContent->room)->category_index)
                    ->where('language_id', $language->id)
                    ->first();
                $roomContent->category_name = optional($roomCategory)->name;
                $roomContent->category_slug = optional($roomCategory)->slug;
                return $roomContent;
            });

        $hasRoom = false;
        foreach ($queryResult['roomInfos'] as $hotelRoom) {
            if (!is_null($hotelRoom->room)) {
                $hasRoom = true;
            }
        }

        $queryResult['roomFlag'] = ($hasRoom === true) ? 1 : 0;

        $queryResult['currencyInfo'] = MiscellaneousTrait::getCurrencyInfo();
        $queryResult['serviceInfos'] = ServiceContent::select('user_service_contents.*')
            ->join('user_services', 'user_service_contents.service_id', '=', 'user_services.id')
            ->where('user_service_contents.language_id', $language->id)
            ->where('user_services.is_featured', 1)
            ->orderBy('user_services.serial_number', 'asc')
            ->with('service')
            ->get();

        $queryResult['numOfBed']  = Room::where('status', 1)->max('bed');
        $queryResult['numOfBath'] = Room::where('status', 1)->max('bath');

        // check whether featured service available or not (start)
        $hotelServices = $queryResult['serviceInfos'];
        $hasService    = false;
        foreach ($hotelServices as $hotelService) {
            if (! is_null($hotelService->service)) {
                $hasService = true;
            }
        }

        $queryResult['serviceFlag'] = ($hasService === true) ? 1 : 0;
        // check whether featured service available or not (end)
        $queryResult['packageInfos'] = PackageContent::with(['package' => function ($query) {
            $query->where('is_featured', 1);
        }])->where('language_id', $language->id)
            ->get();
        // check whether featured package available or not (start)
        $tourPackages = $queryResult['packageInfos'];
        $hasPackage   = false;
        foreach ($tourPackages as $tourPackage) {
            if (! is_null($tourPackage->package)) {
                $hasPackage = true;
            }
        }

        $queryResult['packageFlag'] = ($hasPackage === true) ? 1 : 0;
        // check whether featured package available or not (end)
        $queryResult['facilities'] = Facility::where('language_id', $language->id)->get();

        $queryResult['testimonials'] = Testimonial::where('language_id', $language->id)
            ->orderBy('serial_number', 'asc')
            ->get();
        $queryResult['brands'] = Brand::where('language_id', $language->id)
            ->orderBy('serial_number', 'asc')
            ->get();

        $queryResult['faqs'] = FAQ::where('language_id', $language->id)
            ->orderby('serial_number', 'asc')
            ->get();

        if (in_array('Blog', $packageFeatures)) {
            $queryResult['blogInfos'] = BlogInformation::with('blog')
                ->where('language_id', $language->id)->where('user_id', $user->id)
                ->orderBy('blog_id', 'desc')
                ->limit(3)
                ->get();
        }

        $queryResult['language'] = $language;

        $userBs    = BasicSetting::query()->where('user_id', $user->id)->first();
        $themeInfo = $userBs;
        if (in_array($userBs->theme_version, ['theme_three'])) {
            $queryResult['room_categories'] = RoomCategory::where('user_id', $user->id)->where('language_id', $language->id)->where('status', 1)
                ->orderBy('serial_number', 'asc')
                ->get()
                ->take(6);

            $queryResult['featured_rooms'] = RoomContent::with('room')
                ->where('language_id', $language->id)
                ->join('user_rooms', 'user_room_contents.room_id', '=', 'user_rooms.id')
                ->where('user_rooms.is_featured', 1)
                ->orderBy('user_rooms.id', 'desc')
                ->get();

            $queryResult['latestRoomInfos']  = RoomContent::with('room')
            ->whereHas('room', function ($query) {
                $query->where('status', 1);              
            })
            ->where('language_id', $language->id)
            ->where('user_id', $user->id)
            ->get()
            ->map(function ($roomContent) use ($language) {
                $roomCategory = RoomCategory::where('indx', optional($roomContent->room)->category_index)
                    ->where('language_id', $language->id)
                    ->first();
                $roomContent->category_name = optional($roomCategory)->name;
                $roomContent->category_slug = optional($roomCategory)->slug;
                return $roomContent;
            });
        }
        
        if (in_array($userBs->theme_version, ['theme_four'])) {
            
            if (in_array('Tour Package', $packageFeatures)) {
                
                $queryResult['package_locations'] = PackageLocation::query()
                    ->where('user_id', $user->id)
                    ->where('language_id', $language->id)
                    ->with('packageInfo')
                    ->get();
                    
                $queryResult['maxDays'] = Package::where('user_id', $user->id)
                    ->max('number_of_days');

                $queryResult['package_categories'] = PackageCategory::where('language_id', $language->id)
                        ->where('status', 1)
                        ->orderBy('serial_number', 'asc')
                        ->get();

                $queryResult['featured_tour_packages'] = PackageContent::with('package')
                    ->where('language_id', $language->id)
                    ->join('user_packages', 'user_package_contents.package_id', '=', 'user_packages.id')
                    ->where('user_packages.is_featured',1)
                    ->orderBy('user_packages.id', 'desc')
                    ->get();
                        
                $queryResult['all_tour_packages'] = PackageContent::with('package')
                ->where('language_id', $language->id)
                ->join('user_packages', 'user_package_contents.package_id', '=', 'user_packages.id')
                ->orderBy('user_packages.id', 'desc')
                ->get();
            
            }
        }

        if (in_array($userBs->theme_version, ['theme_five'])) {
            if (in_array('Tour Package', $packageFeatures)) {
        
                $queryResult['package_categories'] = PackageCategory::where('language_id', $language->id)
                    ->where('status', 1)
                    ->orderBy('serial_number', 'asc')
                    ->get()
                    ->take(6);

                $queryResult['all_tour_packages'] = PackageContent::with('package')
                    ->where('language_id', $language->id)
                    ->join('user_packages', 'user_package_contents.package_id', '=', 'user_packages.id')
                    ->orderBy('user_packages.id', 'desc')
                    ->get();
            }

        }

        if ($userBs->home_version == 'slider' || in_array($userBs->theme_version, ['theme_one', 'theme_two','theme_three','theme_four','theme_five'])) {
            $queryResult['sliders'] = HeroSlider::where('language_id', $language->id)->where('user_id', $user->id)
                ->orderBy('serial_number', 'asc')
                ->get();
        }
        //custom sections
        $customSections = [];

        if ($userBs->theme_version === ThemeVersion::ThemeOne->value) {
            $customSections = CustomSection::TenantFrontThemeOne($user->id);
        }
        if ($userBs->theme_version === ThemeVersion::ThemeTwo->value) {
            $customSections = CustomSection::TenantFrontThemeTwo($user->id);
        }
        if ($userBs->theme_version === ThemeVersion::ThemeThree->value) {
            $customSections = CustomSection::TenantFrontThemeThree($user->id);
        }
        if ($userBs->theme_version === ThemeVersion::ThemeFour->value) {
            $customSections = CustomSection::TenantFrontThemeFour($user->id);
        }
        if ($userBs->theme_version === ThemeVersion::ThemeFive->value) {
            $customSections = CustomSection::TenantFrontThemeFive($user->id);
        }
        foreach ($customSections as $section) {
            $queryResult["after_" . str_replace('_section', '', $section)] = AdditionalSection::where('possition', $section)
                ->where('user_id', $user->id)
                ->where('page_type', 'home')
                ->orderBy('serial_number', 'asc')
                ->get();
        }
      

    
        if ($themeInfo->theme_version === ThemeVersion::ThemeOne->value) {
            return view('user-front.themeOne.index', $queryResult);
        } else if ($themeInfo->theme_version === ThemeVersion::ThemeTwo->value) {
            return view('user-front.themeTwo.index', $queryResult);
        } else if ($themeInfo->theme_version === ThemeVersion::ThemeThree->value) {
            return view('user-front.themeThree.index', $queryResult);
        } else if ($themeInfo->theme_version === ThemeVersion::ThemeFour->value) {
            return view('user-front.themeFour.index', $queryResult);
        } else if ($themeInfo->theme_version === ThemeVersion::ThemeFive->value) {
            return view('user-front.themeFive.index', $queryResult);
        }
    }

    public function userAbout()
    {
        $user = getUser();
        $language = MiscellaneousTrait::getLanguage();
        $queryResult['language'] = $language;
        $queryResult['seo'] = $this->getUserSeoData($language, $user->id);
        $queryResult['breadcrumbInfo'] = MiscellaneousTrait::getBreadcrumb();
        $queryResult['pageHeading'] = $this->getUserPageHeading($language, $user->id);
        $queryResult['secHeading'] = SectionHeading::where('language_id', $language->id)->where('user_id', $user->id)->first();
        $queryResult['facilities'] = Facility::where('language_id', $language->id)
            ->inRandomOrder()
            ->take(3)
            ->get();
        $queryResult['counterInfos'] = IntroCountInfo::where('language_id', $language->id)->where('user_id', $user->id)
            ->inRandomOrder()
            ->take(2)
            ->get();
        $queryResult['testimonials'] = Testimonial::where('language_id', $language->id)
            ->orderBy('serial_number', 'asc')
            ->get();

        //custom section
        $sections = CustomSection::AboutUsPage();
        $pageType = 'about';
        foreach ($sections as $section) {
            $queryResult["after_" . str_replace('_section', '', $section)] = AdditionalSection::where('possition', $section)
                ->where('page_type', $pageType)
                ->orderBy('serial_number', 'asc')
                ->get();
        }

        return view('user-front.common.about', $queryResult);
    }
    public function changeUserLanguage($domain)
    {

        $user = getUser();
        session()->put('user_front_lang', request()->lang_code);
        if (request()->lang_code == 'ar') {
            $lan = Language::where('code', request()->lang_code)->where('user_id', $user->id)->first();
            $lan->update(['rtl' => 1]);
        } else {
            $lan = Language::where('code', request()->lang_code)->where('user_id', $user->id)->first();
            $lan->update(['rtl' => 0]);
        }
        return redirect()->route('front.user.detail.view', $domain);
    }
    public function removeMaintenance($domain, $token)
    {
        Session::put('user-bypass-token', $token);
        return redirect()->route('front.user.detail.view', getParam());
    }
    public function contactMessage(Request $request, $domain)
    {
        $rules = [
            'fullname' => 'required',
            'email' => 'required|email:rfc,dns',
            'subject' => 'required',
            'message' => 'required'
        ];

        $request->validate($rules);

        $toUser = getUser();
        $data['toMail'] = $toUser->email;
        $data['toName'] = $toUser->username;
        $data['subject'] = $request->subject;
        $data['body'] = "<div>$request->message</div><br>
                         <strong>For further contact with the enquirer please use the below information:</strong><br>
                         <strong>Enquirer Name:</strong> $request->fullname <br>
                         <strong>Enquirer Mail:</strong> $request->email <br>
                         ";
        $data['fullname'] = $request->fullname;
        $data['email'] = $request->email;
        $mailer = new MegaMailer();
        $mailer->mailContactMessage($data);
        Session::flash('success', __('Mail Sent Successfully'));
        return back();
    }
    public function userCPage($domain, $slug)
    {
        $user = getUser();
        $language = MiscellaneousTrait::getLanguage();
        $queryResult['bgImg'] = $this->getUserBreadcrumb($user->id);
        $queryResult['pageInfo'] = Page::query()
            ->join('user_page_contents', 'user_pages.id', '=', 'user_page_contents.page_id')
            ->where('user_pages.status', '=', 1)
            ->where('user_pages.user_id', '=', $user->id)
            ->where('user_page_contents.language_id', '=', $language->id)
            ->where('user_page_contents.slug', '=', $slug)
            ->firstOrFail();

        return view('user-front.common.custom-page', $queryResult);
    }
}
