<?php

namespace App\Http\Controllers\FrontEnd;

use App\Http\Controllers\Controller;
use App\Models\User\HomePage\SectionHeading;
use App\Models\User\ServiceContent;
use App\Traits\MiscellaneousTrait;
use Illuminate\Support\Facades\DB;

class ServiceController extends Controller
{
  use MiscellaneousTrait;

  public function services($domain)
  {
    $user = getuser();
    $queryResult['breadcrumbInfo'] = MiscellaneousTrait::getBreadcrumb();
    $language = MiscellaneousTrait::getLanguage();
    $queryResult['pageHeading'] = $this->getUserPageHeading($language, $user->id);

    $queryResult['secHeading'] = SectionHeading::where('language_id', $language->id)
      ->select('service_section_title', 'service_section_subtitle')
      ->first();

    $queryResult['serviceInfos'] = DB::table('user_services')
      ->join('user_service_contents', 'user_services.id', '=', 'user_service_contents.service_id')
      ->where('user_service_contents.language_id', '=', $language->id)
      ->where('user_services.user_id', '=', $user->id)
      ->where('user_service_contents.user_id', '=', $user->id)
      ->where('user_services.is_featured',1)
      ->orderBy('user_services.serial_number', 'asc')
      ->get();
    $queryResult['seo'] = $this->getUserSeoData($language, $user->id);
    return view('user-front.common.service.services', $queryResult);
  }

  public function serviceDetails($domain, $slug)
  {
    $user = getuser();
    $queryResult['breadcrumbInfo'] = MiscellaneousTrait::getBreadcrumb();
    $language = MiscellaneousTrait::getLanguage();
    $queryResult['details'] = ServiceContent::with('service')
      ->where('language_id', $language->id)
      ->where('user_id', $user->id)
      ->where('slug', $slug)
      ->firstOrFail();
    $id = $queryResult['details']->service_id;
    $queryResult['moreServices'] = ServiceContent::with('service')->where('language_id', $language->id)->where('user_id', $user->id)
      ->where('service_id', '<>', $id)
      ->get();
    
    return view('user-front.common.service.service_details', $queryResult);
  }
}
