<?php

namespace App\Http\Controllers\FrontEnd\Room;

use App\Constants\Constant;
use DateTime;
use App\Models\User\Language;
use App\Models\User\Room;
use App\Models\User\Coupon;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use App\Http\Helpers\MegaMailer;
use App\Models\User\RoomAmenity;
use App\Models\User\RoomBooking;
use App\Models\User\RoomContent;
use App\Traits\MiscellaneousTrait;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use App\Http\Requests\RoomBookingRequest;
use App\Http\Controllers\FrontEnd\Room\PaytmController;
use App\Http\Controllers\FrontEnd\Room\MollieController;
use App\Http\Controllers\FrontEnd\Room\PayPalController;
use App\Http\Controllers\FrontEnd\Room\StripeController;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use App\Http\Controllers\FrontEnd\Room\PaystackController;
use App\Http\Controllers\FrontEnd\Room\RazorpayController;
use App\Http\Controllers\FrontEnd\Room\InstamojoController;
use App\Http\Controllers\FrontEnd\Room\FlutterwaveController;
use App\Http\Controllers\FrontEnd\Room\MercadoPagoController;
use App\Models\User;
use App\Models\User\BasicSetting;
use Illuminate\Support\Facades\Session;
use Barryvdh\DomPDF\Facade\Pdf;

class RoomBookingController extends Controller
{
  use MiscellaneousTrait;

  public function makeRoomBooking(RoomBookingRequest $request)
  {
    // check whether user is logged in or not (start)
    $status = DB::table('user_basic_settings')->select('room_guest_checkout_status')
      ->where('user_id', getUser()->id)
      ->where('uniqid', '=', 12345)
      ->first();

    if (($status->room_guest_checkout_status == 0) && (Auth::guard('customer')->check() == false)) {
      return redirect()->route('customer.login', [getParam(), 'redirectPath' => 'room_details']);
    }
    // check whether user is logged in or not (end)

    if ($request->paymentType == 'paypal') {
      $paypal = new PayPalController();
      return $paypal->bookingProcess($request);
    } else if ($request->paymentType == 'stripe') {
      $stripe = new StripeController();

      return $stripe->bookingProcess($request);
    } else if ($request->paymentType == 'paytm') {
      $paytm = new PaytmController();

      return $paytm->bookingProcess($request);
    } else if ($request->paymentType == 'instamojo') {
      $instamojo = new InstamojoController();

      return $instamojo->bookingProcess($request);
    } else if ($request->paymentType == 'paystack') {
      $paystack = new PaystackController();

      return $paystack->bookingProcess($request);
    } else if ($request->paymentType == 'authorize.net') {
      $authorizenet = new AuthorizenetController();

      return $authorizenet->bookingProcess($request);
    } else if ($request->paymentType == 'flutterwave') {
      $flutterwave = new FlutterwaveController();

      return $flutterwave->bookingProcess($request);
    } else if ($request->paymentType == 'mollie') {
      $mollie = new MollieController();

      return $mollie->bookingProcess($request);
    } else if ($request->paymentType == 'razorpay') {
      $razorpay = new RazorpayController();

      return $razorpay->bookingProcess($request);
    } else if ($request->paymentType == 'mercadopago') {
      $mercadopago = new MercadoPagoController();

      return $mercadopago->bookingProcess($request);
    } else {
      $offline = new OfflineController();
      return $offline->bookingProcess($request);
    }
  }

  public function calculation(Request $request)
  {
    $userBs = BasicSetting::where('user_id',getUser()->id)->first();
    $roomInfo = Room::findOrFail($request->room_id);
    $userTotal = floatval($roomInfo->rent) * intval($request->nights);
    $adminProfit = 0;
    $room_fee = $userBs->room_fee_status == 1 ?  $userBs->room_fee : 0.00;

    if (Session::has('couponCode')) {
      $coupon_code = Session::get('couponCode');
      $coupon = Coupon::where('code', $coupon_code)->where('user_id', getUser()->id)->first();
      if (!is_null($coupon)) {
        $couponVal = floatval($coupon->value);
        if ($coupon->type == 'fixed') {
          $subtotal = $userTotal - $couponVal;
          $room_tax = $userBs->room_tax_status == 1 ? $this->tax(($subtotal), $userBs->room_tax) : 0.00;
          $total = ($subtotal + $room_tax + $room_fee) ;
          $calculatedData = array(
            'subtotal' => $subtotal,
            'discount' => $couponVal,
            'tax' => $room_tax,
            'fee' => $room_fee,
            'total' => $total,
            'adminProfit' =>  $adminProfit,
            'userTotal' => $userTotal
          );
        } else {
          $discount = $userTotal * ($couponVal / 100);
          $subtotal = $userTotal - $discount;
          $room_tax = $userBs->room_tax_status == 1 ? $this->tax(($subtotal), $userBs->room_tax) : 0.00;
          $total = ($subtotal + $room_tax + $room_fee);
          $adminProfit = 0;
          $calculatedData = array(
            'subtotal' => $subtotal,
            'discount' => $discount,
            'tax' => $room_tax,
            'fee' => $room_fee,
            'total' => $total,
            'adminProfit' =>  $adminProfit,
            'userTotal' => $userTotal
          );
        }
      } else {
        $discount = 0.00;
        $subtotal = $userTotal - $discount;
        $room_tax = $userBs->room_tax_status == 1 ? $this->tax(($subtotal), $userBs->room_tax) : 0.00;
        $total = ($subtotal + $room_tax + $room_fee);
        $calculatedData = array(
          'subtotal' => $subtotal,
          'discount' => $discount,
          'tax' => $room_tax,
          'fee' => $room_fee,
          'total' => $total,
          'adminProfit' =>  $adminProfit,
          'userTotal' => $userTotal
        );
      }
    } else {

      $discount = 0.00;
      $subtotal = $userTotal - $discount;
      $room_tax = $userBs->room_tax_status == 1 ? $this->tax(($subtotal), $userBs->room_tax) : 0.00;
      $total = ($subtotal + $room_tax + $room_fee);
      $calculatedData = array(
        'subtotal' => $subtotal,
        'discount' => $discount,
        'tax' => $room_tax,
        'fee' => $room_fee,
        'total' => $total,
        'adminProfit' =>  $adminProfit,
        'userTotal' => $userTotal
      );
    }

    Session::forget('couponCode');

    return $calculatedData;
  }

  public function storeData(Request $request, $information)
  {
    $user = User::with(['memberships' => function ($q) {
      $q->where('status', 1)
        ->whereDate('start_date', '<=', Carbon::today())
        ->whereDate('expire_date', '>=', Carbon::today());
    }])->where('id', getUser()->id)->first();
    if (!is_null($user) && $user->memberships->isNotEmpty()) {
      $membership_id =  $user->memberships->first()->id;
    }

    $dateArray = explode(' ', $request->dates);

    $booking_details = RoomBooking::create([
      'booking_number' => time(),
      'user_id' => getUser()->id,
      'user_membership_id' => isset($membership_id) ? $membership_id : null,
      'customer_id' => Auth::guard('customer')->check() ? Auth::guard('customer')->user()->id : NULL,
      'customer_name' => $request->customer_name,
      'customer_email' => $request->customer_email,
      'customer_phone' => $request->customer_phone,
      'room_id' => $request->room_id,
      'arrival_date' => $dateArray[0],
      'departure_date' => $dateArray[2],
      'guests' => $request->guests,
      'subtotal' => $information['subtotal'],
      'discount' => $information['discount'],
      'tax' => $information['tax'],
      'fee' => $information['fee'],
      'grand_total' => $information['total'],
      'actual_total' => $information['userTotal'],
      'currency_symbol' => $information['currency_symbol'],
      'currency_symbol_position' => $information['currency_symbol_position'],
      'currency_text' => $information['currency_text'],
      'currency_text_position' => $information['currency_text_position'],
      'payment_method' => $information['method'],
      'gateway_type' => $information['type'],
      'attachment' => $request->hasFile('attachment') ? $information['attachment'] : null
    ]);
    return $booking_details;
  }

  public function generateInvoice($bookingInfo)
  {
    
    $fileName = $bookingInfo->booking_number . '.pdf';
    $directory = public_path(Constant::WEBSITE_ROOM_BOOKING_INVOICE . '/');
    @mkdir($directory, 0777, true);
    $fileLocated = $directory . $fileName;
    $user = getUser();
    $language = Language::query()->where('is_default', '=', 1)->where('user_id', '=', $user->id)->first();
    $keywords = get_keywords($user->id);
    Pdf::setOptions([
      'isHtml5ParserEnabled' => true,
      'isRemoteEnabled' => true,
      'logOutputFile' => storage_path('logs/log.htm'),
      'tempDir' => storage_path('logs/'),
    ])->loadView('user-front.common.pdf.room_booking', compact('bookingInfo', 'language', 'keywords', 'user'))->save($fileLocated);
    return $fileName;
  }

  public function sendMail($bookingInfo)
  {
    // second get the website title & mail's smtp information from db
    $info = DB::table('basic_extendeds')->first();
    $infoCus = DB::table('user_basic_settings')->first();

    // get the difference of two dates, date should be in 'YYYY-MM-DD' format
    $date1 = new DateTime($bookingInfo->arrival_date);
    $date2 = new DateTime($bookingInfo->departure_date);
    $interval = $date1->diff($date2, true);

    // get the room category name according to language
    $language = MiscellaneousTrait::getLanguage();

    $roomContent = RoomContent::where('language_id', $language->id)
      ->where('room_id', $bookingInfo->room_id)
      ->first();
    $room = Room::where('id', $bookingInfo->room_id)->first();

    $roomCategory = $room->roomCategory()->where('language_id', $language->id)->first();
    $roomCategoryName = !is_null($roomCategory) ? $roomCategory->name : '';
    $roomRent = ($bookingInfo->currency_text_position == 'left' ? $bookingInfo->currency_text . ' ' : '') . $bookingInfo->grand_total . ($bookingInfo->currency_text_position == 'right' ? ' ' . $bookingInfo->currency_text : '');

    // get the amenities of booked room
    $amenityIds = json_decode($room->amenities_index);
    $amenityArray = [];

    foreach ($amenityIds as $id) {
      $amenity = RoomAmenity::where('indx', $id)->where('language_id', $language->id)->first();
      if (!is_null($amenity)) {
        array_push($amenityArray, $amenity->name);
      }
    }

    // now, convert amenity array into comma separated string
    $amenityString = implode(', ', $amenityArray);

    


    $mailer = new MegaMailer();
    $data = [
      'toMail' => $bookingInfo->customer_email,
      'toName' =>  $bookingInfo->customer_name,
      'customer_name' => $bookingInfo->customer_name,
      'room_name' => $roomContent->title,
      'room_rent' => $roomRent,
      'booking_number' => $bookingInfo->booking_number,
      'booking_date' =>  date_format($bookingInfo->created_at, 'F d, Y'),
      'number_of_night' =>  $interval->days,
      'website_title' => $infoCus->website_title,
      'check_in_date' => $bookingInfo->arrival_date,
      'discount' => $bookingInfo->discount ?? 0,
      'check_out_date' => $bookingInfo->departure_date,
      'number_of_guests' => $bookingInfo->guests,
      'room_type' => $roomCategoryName,
      'room_amenities' => $amenityString,
      'invoice' => public_path(Constant::WEBSITE_ROOM_BOOKING_INVOICE . '/' . $bookingInfo->invoice),
      'templateType' => $bookingInfo->gateway_type == 'Offline' ? 'room_booking_for_offline_gateway': 'room_booking_for_online_gateway',
      'type' => 'roombooking'
    ];
   
    $mailer->mailFromUser($data, getUser());
  }

  public function applyCoupon(Request $request)
  {

    $keywords = get_keywords(getUser()->id);

    try {
      $settings = BasicSetting::where('user_id', getUser()->id)->select('room_tax_status', 'room_tax', 'room_fee_status', 'room_fee')->first();
      $coupon = Coupon::where('code', $request->coupon)->where('user_id', getUser()->id)->firstOrFail();
      $startDate = Carbon::parse($coupon->start_date);
      $endDate = Carbon::parse($coupon->end_date);
      $todayDate = Carbon::now();

      // check coupon is valid or not
      if ($todayDate->between($startDate, $endDate) == false) {
        return response()->json(['error' => 'Sorry, coupon has been expired!']);
      }

      // check coupon is valid or not for this rooms
      $roomId = $request->roomId;
      $roomIds = empty($coupon->rooms) ? '' : json_decode($coupon->rooms);

      if (!empty($roomIds) && !in_array($roomId, $roomIds)) {
        return response()->json(['error' => $keywords['You can not apply this coupon for this rooms!'] ?? _('You can not apply this coupon for this rooms!')]);
      }

      Session::put('couponCode', $request->coupon);
      $initTotalRent = str_replace(',', '', $request->initTotal);
      if ($coupon->type == 'fixed') {
        $total = floatval($initTotalRent) - floatval($coupon->value);
        return response()->json([
          'success' => $keywords['Coupon applied successfully.'] ?? __('Coupon applied successfully.'),
          'discount' => $coupon->value,
          'total' => $total,
        ]);
      } else {
        $initTotalRent = floatval($initTotalRent);
        $couponVal = floatval($coupon->value);
        $discount = $initTotalRent * ($couponVal / 100);
        $total = $initTotalRent - $discount;
        return response()->json([
          'success' =>  $keywords['Coupon applied successfully.'] ?? __('Coupon applied successfully.'),
          'discount' => $discount,
          'total' => $total
        ]);
      }
    } catch (ModelNotFoundException $e) {
      return response()->json(['error' =>  $keywords['Coupon is not valid!'] ?? __('Coupon is not valid!')]);
    }
  }
  public function removeCoupon(Request $request)
  {
    if (Session::has('couponCode')) {
      Session::forget('couponCode');
    }
    return "success";
  }

  public function total_amount($subtotal, $coupon, $fee, $tax)
  {
    return (floatval($subtotal)  + floatval($fee) + floatval($tax)) - (floatval($coupon));
  }

  public function complete()
  {
    $queryResult['breadcrumbInfo'] = MiscellaneousTrait::getBreadcrumb();
    return view('user-front.common.partials.payment_success', $queryResult);
  }

  public function cancel()
  {
    $keywords = get_keywords(getUser()->id);
    return redirect()->route('rooms', getParam())->with('error', $keywords['Sorry, an error has occured!'] ?? __('Sorry, an error has occured!'));
  }
}
