<?php

namespace App\Http\Controllers\FrontEnd\Room;

use Anand\LaravelPaytmWallet\Facades\PaytmWallet;
use App\Http\Controllers\Controller;
use App\Http\Controllers\FrontEnd\Room\RoomBookingController;
use App\Http\Helpers\LimitCheckerHelper;
use App\Models\User\PaymentGateway;
use App\Models\User\RoomBooking;
use App\Traits\MiscellaneousTrait;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Session;

class PaytmController extends Controller
{
  public  $paydata ;
  public function __construct()
  {
    $data = PaymentGateway::where('keyword', 'paytm')->where('user_id', getUser()->id)->first();
    $paydata = $data->convertAutoData();
    $this->paydata = $paydata;
    Config::set('services.paytm-wallet.env', $paydata['environment']);
    Config::set('services.paytm-wallet.merchant_id', $paydata['merchant']);
    Config::set('services.paytm-wallet.merchant_key', $paydata['secret']);
    Config::set('services.paytm-wallet.merchant_website', $paydata['website']);
    Config::set('services.paytm-wallet.industry_type', $paydata['industry']);
    Config::set('services.paytm-wallet.channel', 'WEB');
  }

  public function bookingProcess(Request $request)
  {

    if (empty($this->paydata)) {
      return back()->with('error', 'Payment credentails not set yet');
    }

    $countRoomBooking = LimitCheckerHelper::roomBookingCountUser(getUser()->id);
    $roomBookingLimit = LimitCheckerHelper::roomBookingsLimit(getUser()->id);
    
    if ($roomBookingLimit > $countRoomBooking) {
      $roomBooking = new RoomBookingController();
      // do calculation
      $calculatedData = $roomBooking->calculation($request);
      $currencyInfo = MiscellaneousTrait::getCurrencyInfo();
      // checking whether the currency is set to 'INR' or not
      if ($currencyInfo->base_currency_text !== 'INR') {
        return redirect()->back()->with('error', __('Invalid currency for paytm payment.'));
      }

      $information['subtotal'] = $calculatedData['subtotal'];
      $information['discount'] = $calculatedData['discount'];
      $information['total'] = $calculatedData['total'];
      $information['userTotal'] = $calculatedData['userTotal'];
      $information['tax']       = $calculatedData['tax'];
      $information['fee']       = $calculatedData['fee'];
      $information['currency_symbol'] = $currencyInfo->base_currency_symbol;
      $information['currency_symbol_position'] = $currencyInfo->base_currency_symbol_position;
      $information['currency_text'] = $currencyInfo->base_currency_text;
      $information['currency_text_position'] = $currencyInfo->base_currency_text_position;
      $information['method'] = 'Paytm';
      $information['type'] = 'online';

      // store the room booking information in database
      $booking_details = $roomBooking->storeData($request, $information);
      $payment = PaytmWallet::with('receive');
      $payment->prepare([
        'order' => time(),
        'user' => uniqid(),
        'mobile_number' => $booking_details->customer_phone,
        'email' => $booking_details->customer_email,
        'amount' => round($calculatedData['total'],2),
        'callback_url' => route('room_booking.paytm.notify', getParam())
      ]);

      // put some data in session before redirect to paytm url
      Session::put('bookingId', $booking_details->id);   // db row number
      return $payment->receive();
    } else {
      return redirect()->back()->with('error', __('Please Contact Support'));
    }
  }


  function getAllEncdecFunc()
  {
    function encrypt_e($input, $ky)
    {
      $key = html_entity_decode($ky);
      $iv = "@@@@&&&&####$$$$";
      $data = openssl_encrypt(
        $input,
        "AES-128-CBC",
        $key,
        0,
        $iv
      );
      return $data;
    }

    function decrypt_e($crypt, $ky)
    {
      $key = html_entity_decode($ky);
      $iv = "@@@@&&&&####$$$$";
      $data = openssl_decrypt($crypt, "AES-128-CBC", $key, 0, $iv);
      return $data;
    }

    function pkcs5_pad_e($text,$blocksize) {
      $pad = $blocksize - (strlen($text) % $blocksize);
      return $text . str_repeat(chr($pad), $pad);
    }

    function pkcs5_unpad_e($text)
    {
      $pad = ord($text[strlen($text) - 1]);
      if ($pad > strlen($text))
        return false;
      return substr($text, 0, -1 * $pad);
    }

    function generateSalt_e($length){
      $random = "";
      srand((float)microtime() * 1000000);
      $data = "AbcDE123IJKLMN67QRSTUVWXYZ";
      $data .= "aBCdefghijklmn123opq45rs67tuv89wxyz";
      $data .= "0FGH45OP89";
      for ($i = 0; $i < $length; $i++) {
        $random .= substr($data, (rand() % (strlen($data))), 1);
      }
      return $random;
    }

    function checkString_e($value)
    {
      if ($value == 'null')
        $value = '';
      return $value;
    }

    function getChecksumFromArray($arrayList, $key, $sort = 1)
    {
      if ($sort != 0) {
        ksort($arrayList);
      }
      $str = getArray2Str($arrayList);
      $salt = generateSalt_e(4);
      $finalString = $str . "|" . $salt;
      $hash = hash("sha256", $finalString);
      $hashString = $hash . $salt;
      $checksum = encrypt_e($hashString, $key);
      return $checksum;
    }

    function getChecksumFromString($str, $key)
    {
      $salt = generateSalt_e(4);
      $finalString = $str . "|" . $salt;
      $hash = hash("sha256", $finalString);
      $hashString = $hash . $salt;
      $checksum = encrypt_e($hashString, $key);
      return $checksum;
    }

    function verifychecksum_e($arrayList, $key, $checksumvalue)
    {
      $arrayList = removeCheckSumParam($arrayList);
      ksort($arrayList);
      $str = getArray2StrForVerify($arrayList);
      $paytm_hash = decrypt_e($checksumvalue, $key);
      $salt = substr($paytm_hash, -4);
      $finalString = $str . "|" . $salt;
      $website_hash = hash("sha256", $finalString);
      $website_hash .= $salt;
      $validFlag = "FALSE";
      if ($website_hash == $paytm_hash) {
        $validFlag = "TRUE";
      } else {
        $validFlag = "FALSE";
      }
      return $validFlag;
    }

    function verifychecksum_eFromStr($str, $key, $checksumvalue)
    {
      $paytm_hash = decrypt_e($checksumvalue, $key);
      $salt = substr($paytm_hash, -4);
      $finalString = $str . "|" . $salt;
      $website_hash = hash("sha256", $finalString);
      $website_hash .= $salt;
      $validFlag = "FALSE";
      if ($website_hash == $paytm_hash) {
        $validFlag = "TRUE";
      } else {
        $validFlag = "FALSE";
      }
      return $validFlag;
    }

    function getArray2Str($arrayList)
    {
      $findme = 'REFUND';
      $findmepipe = '|';
      $paramStr = "";
      $flag = 1;
      foreach ($arrayList as $key => $value) {
        $pos = strpos($value, $findme);
        $pospipe = strpos($value, $findmepipe);
        if ($pos !== false || $pospipe !== false) {
          continue;
        }
        if ($flag) {
          $paramStr .= checkString_e($value);
          $flag = 0;
        } else {
          $paramStr .= "|" . checkString_e($value);
        }
      }
      return $paramStr;
    }

    function getArray2StrForVerify($arrayList)
    {
      $paramStr = "";
      $flag = 1;
      foreach ($arrayList as $key => $value) {
        if ($flag) {
          $paramStr .= checkString_e($value);
          $flag = 0;
        } else {
          $paramStr .= "|" . checkString_e($value);
        }
      }
      return $paramStr;
    }

    function redirect2PG($paramList, $key)
    {
      $hashString = getchecksumFromArray($paramList, $key);
      $checksum = encrypt_e($hashString, $key);
    }

    function removeCheckSumParam($arrayList)
    {
      if (isset($arrayList["CHECKSUMHASH"])) {
        unset($arrayList["CHECKSUMHASH"]);
      }
      return $arrayList;
    }

    function getTxnStatus($requestParamList)
    {
      return callAPI(PAYTM_STATUS_QUERY_URL, $requestParamList);
    }

    function getTxnStatusNew($requestParamList)
    {
      return callNewAPI(PAYTM_STATUS_QUERY_NEW_URL, $requestParamList);
    }

    function initiateTxnRefund($requestParamList)
    {
      $CHECKSUM = getRefundChecksumFromArray($requestParamList, PAYTM_MERCHANT_KEY, 0);
      $requestParamList["CHECKSUM"] = $CHECKSUM;
      return callAPI(PAYTM_REFUND_URL, $requestParamList);
    }

    function callAPI( $apiURL, $requestParamList) {
      $jsonResponse = "";
      $responseParamList = array();
      $JsonData = json_encode($requestParamList);
      $postData = 'JsonData=' . urlencode($JsonData);
      $ch = curl_init($apiURL);
      curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
      curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
      curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
      curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
      curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
      curl_setopt(
        $ch,
        CURLOPT_HTTPHEADER,
        array(
          'Content-Type: application/json',
          'Content-Length: ' . strlen($postData)
        )
      );
      $jsonResponse = curl_exec($ch);
      $responseParamList = json_decode($jsonResponse, true);
      return $responseParamList;
    }

    function callNewAPI($apiURL, $requestParamList)
    {
      $jsonResponse = "";
      $responseParamList = array();
      $JsonData = json_encode($requestParamList);
      $postData = 'JsonData=' . urlencode($JsonData);
      $ch = curl_init($apiURL);
      curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
      curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
      curl_setopt(
        $ch,
        CURLOPT_RETURNTRANSFER,
        true
      );
      curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
      curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
      curl_setopt(
        $ch,
        CURLOPT_HTTPHEADER,
        array(
          'Content-Type: application/json',
          'Content-Length: ' . strlen($postData)
        )
      );
      $jsonResponse = curl_exec($ch);
      $responseParamList = json_decode($jsonResponse, true);
      return $responseParamList;
    }

    function getRefundChecksumFromArray($arrayList, $key, $sort = 1)
    {
      if ($sort != 0) {
        ksort($arrayList);
      }
      $str = getRefundArray2Str($arrayList);
      $salt = generateSalt_e(4);
      $finalString = $str . "|" . $salt;
      $hash = hash("sha256", $finalString);
      $hashString = $hash . $salt;
      $checksum = encrypt_e($hashString, $key);
      return $checksum;
    }

    function getRefundArray2Str($arrayList)
    {
      $findmepipe = '|';
      $paramStr = "";
      $flag = 1;
      foreach ($arrayList as $key => $value) {
        $pospipe = strpos($value, $findmepipe);
        if ($pospipe !== false) {
          continue;
        }
        if ($flag) {
          $paramStr .= checkString_e($value);
          $flag = 0;
        } else {
          $paramStr .= "|" . checkString_e($value);
        }
      }
      return $paramStr;
    }

    function callRefundAPI($refundApiURL, $requestParamList)
    {
      $jsonResponse = "";
      $responseParamList = array();
      $JsonData = json_encode($requestParamList);
      $postData = 'JsonData=' . urlencode($JsonData);
      $ch = curl_init($refundApiURL);
      curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
      curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
      curl_setopt($ch, CURLOPT_URL, $refundApiURL);
      curl_setopt($ch, CURLOPT_POST, true);
      curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
      curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
      $headers = array();
      $headers[] = 'Content-Type: application/json';
      curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
      $jsonResponse = curl_exec($ch);
      return json_decode($jsonResponse, true);
    }
  }


  public function notify(Request $request)
  {
    // get the information from session
    $bookingId = Session::get('bookingId');
    
    if($request['STATUS'] === 'TXN_SUCCESS') {
      // update the payment status for room booking in database
      $bookingInfo = RoomBooking::findOrFail($bookingId);
      $bookingInfo->update(['payment_status' => 1]);
      $roomBooking = new RoomBookingController();
      // generate an invoice in pdf format
      $invoice = $roomBooking->generateInvoice($bookingInfo);
      // update the invoice field information in database
      $bookingInfo->update(['invoice' => $invoice]);
      // send a mail to the customer with an invoice
      $roomBooking->sendMail($bookingInfo);

      // remove all session data
      Session::forget('bookingId');
      return redirect()->route('room_booking.complete', getParam());
    } else{
      session()->flash('error', __('Cancel payment'));
      return redirect()->route('rooms',getParam());
    }
  }
}
