<?php
namespace App\Http\Controllers\FrontEnd\Room;

use App\Http\Controllers\Controller;
use App\Http\Controllers\FrontEnd\Room\RoomBookingController;
use App\Http\Helpers\Instamojo;
use App\Http\Helpers\LimitCheckerHelper;
use App\Models\Language;
use App\Models\User\PaymentGateway;
use App\Models\USer\RoomBooking;
use App\Traits\MiscellaneousTrait;
use Exception;
use Illuminate\Http\Request;

class InstamojoController extends Controller
{
    use MiscellaneousTrait;

    private $api;
    private $paypalData;

    public function __construct()
    {
        $data          = PaymentGateway::whereKeyword('instamojo')->where('user_id', getUser()->id)->first();
        $instamojoData = $this->paypalData = json_decode($data->information, true);

        if ($instamojoData['sandbox_check'] == 1) {
            $this->api = new Instamojo($instamojoData['key'], $instamojoData['token'], 'https://test.instamojo.com/api/1.1/');
        } else {
            $this->api = new Instamojo($instamojoData['key'], $instamojoData['token']);
        }

    }

    public function bookingProcess(Request $request)
    {
        if (empty($this->paypalData)) {
            return back()->with('error', __('Payment credentails not set yet'));
        }
        $countRoomBooking = LimitCheckerHelper::roomBookingCountUser(getUser()->id);
        $roomBookingLimit = LimitCheckerHelper::roomBookingsLimit(getUser()->id);

        if ($roomBookingLimit > $countRoomBooking) {
            $roomBooking = new RoomBookingController();

            // do calculation
            $calculatedData = $roomBooking->calculation($request);

            $title = 'Room Booking';

            $currencyInfo = MiscellaneousTrait::getCurrencyInfo();

            // checking whether the currency is set to 'INR' or not
            if ($currencyInfo->base_currency_text !== 'INR') {
                return redirect()->back()->with('error', __('Invalid currency for instamojo payment.'));
            }

            $information['subtotal']                 = $calculatedData['subtotal'];
            $information['discount']                 = $calculatedData['discount'];
            $information['total']                    = $calculatedData['total'];
            $information['userTotal']                = $calculatedData['userTotal'];
            $information['tax']                      = $calculatedData['tax'];
            $information['fee']                      = $calculatedData['fee'];
            $information['currency_symbol']          = $currencyInfo->base_currency_symbol;
            $information['currency_symbol_position'] = $currencyInfo->base_currency_symbol_position;
            $information['currency_text']            = $currencyInfo->base_currency_text;
            $information['currency_text_position']   = $currencyInfo->base_currency_text_position;
            $information['method']                   = 'Instamojo';
            $information['type']                     = 'online';

            // store the room booking information in database
            $booking_details = $roomBooking->storeData($request, $information);

            $notify_url = route('room_booking.instamojo.notify', getParam());

            try {
                $booking_details = $roomBooking->storeData($request, $information);
                $response        = $this->api->paymentRequestCreate([
                    'purpose'      => $title,
                    'amount'       => round($calculatedData['total'],2),
                    'buyer_name'   => $booking_details->username,
                    'email'        => $booking_details->email,
                    'send_email'   => false,
                    'phone'        => $booking_details->contact_number,
                    'send_sms'     => false,
                    'redirect_url' => $notify_url,
                ]);

                                                                             // put some data in session before redirect to instamojo url
                $request->session()->put('bookingId', $booking_details->id); // db row number
                $request->session()->put('paymentId', $response['id']);

                return redirect($response['longurl']);
            } catch (Exception $e) {
                return redirect()->back()->with('error', __('Sorry, transaction failed!'));
            }

        } else {
            return redirect()->back()->with('error', __('Please Contact Support'));
        }
    }

    public function notify(Request $request)
    {
        // get the information from session
        $bookingId = $request->session()->get('bookingId');
        $paymentId = $request->session()->get('paymentId');

        $urlInfo = $request->all();

        if ($urlInfo['payment_request_id'] == $paymentId) {
            // update the payment status for room booking in database
            $bookingInfo = RoomBooking::findOrFail($bookingId);

            $bookingInfo->update(['payment_status' => 1]);

            $roomBooking = new RoomBookingController();

            // generate an invoice in pdf format
            $invoice = $roomBooking->generateInvoice($bookingInfo);

            // update the invoice field information in database
            $bookingInfo->update(['invoice' => $invoice]);

            // send a mail to the customer with an invoice
            $roomBooking->sendMail($bookingInfo);

            // remove all session data
            $request->session()->forget('bookingId');
            $request->session()->forget('paymentId');

            return redirect()->route('room_booking.complete', getParam());
        } else {
            return redirect()->route('room_booking.cancel', getParam());
        }
    }
}
