<?php

namespace App\Http\Controllers\FrontEnd\Package;

use App\Http\Controllers\Controller;
use App\Http\Controllers\FrontEnd\Package\PackageBookingController;
use App\Http\Helpers\LimitCheckerHelper;
use App\Models\User\PackageBooking;
use App\Models\User\PaymentGateway;
use App\Traits\MiscellaneousTrait;
use Illuminate\Http\Request;

class MercadoPagoController extends Controller
{
  use MiscellaneousTrait;

  private $token, $sandbox_status;
  private $adminBe;
  private $adminBs;

  public function __construct()
  {
      $data = PaymentGateway::whereKeyword('mercadopago')->where('user_id', getUser()->id)->first();
      $mercadopagoData = json_decode($data->information, true);

      $this->token = $mercadopagoData['token'];
      $this->sandbox_status = $mercadopagoData['sandbox_check'];

  }

  public function bookingProcess(Request $request)
  {
    $countPackageBooking = LimitCheckerHelper::packageBookingCountUser(getUser()->id);
    $packageBookingLimit = LimitCheckerHelper::packageBookingsLimit(getUser()->id);

    if ($packageBookingLimit > $countPackageBooking) {
    $packageBooking = new PackageBookingController();

    // do calculation
    $calculatedData = $packageBooking->calculation($request);

    $title = 'Package Booking';

    $available_currency = array('ARS', 'BOB', 'BRL', 'CLF', 'CLP', 'COP', 'CRC', 'CUC', 'CUP', 'DOP', 'EUR', 'GTQ', 'HNL', 'MXN', 'NIO', 'PAB', 'PEN', 'PYG', 'USD', 'UYU', 'VEF', 'VES');

    $currencyInfo = MiscellaneousTrait::getCurrencyInfo();
        // checking whether the base currency is allowed or not
        if (!in_array($currencyInfo->base_currency_text, $available_currency)) {
          return redirect()->back()->with('error', __('Invalid currency for mercadopago payment.'));
        }

        $information['subtotal'] = $calculatedData['subtotal'];
        $information['discount'] = $calculatedData['discount'];
        $information['total'] = $calculatedData['total'];
        $information['userTotal'] = $calculatedData['userTotal'];
        $information['tax']                      = $calculatedData['tax'];
        $information['fee']                      = $calculatedData['fee'];
        $information['currency_symbol'] = $currencyInfo->base_currency_symbol;
        $information['currency_symbol_position'] = $currencyInfo->base_currency_symbol_position;
        $information['currency_text'] = $currencyInfo->base_currency_text;
        $information['currency_text_position'] = $currencyInfo->base_currency_text_position;
        $information['method'] = 'MercadoPago';
        $information['type'] = 'online';

        // store the package booking information in database
        $booking_details = $packageBooking->storeData($request, $information);

        $notify_url = route('package_booking.mercadopago.notify',getParam());
        $complete_url = route('package_booking.complete',getParam());
        $cancel_url = route('package_booking.cancel',getParam());

        $curl = curl_init();

        $preferenceData = [
          'items' => [
            [
              'id' => uniqid(),
              'title' => $title,
              'description' => 'Booking Tour Package Using MercadoPago Gateway',
              'quantity' => 1,
              'currency' => $booking_details->currency_text,
              'unit_price' => intval($calculatedData['total'])
            ]
          ],
          'payer' => [
            'email' => $booking_details->customer_email
          ],
          'back_urls' => [
            'success' => $complete_url,
            'pending' => '',
            'failure' => $cancel_url
          ],
          'notification_url' => $notify_url,
          'auto_return' => 'approved'
        ];

        $httpHeader = ['Content-Type: application/json'];

        $url = 'https://api.mercadopago.com/checkout/preferences?access_token=' . $this->token;

        $curlOPT = [
          CURLOPT_URL             => $url,
          CURLOPT_CUSTOMREQUEST   => 'POST',
          CURLOPT_POSTFIELDS      => json_encode($preferenceData, true),
          CURLOPT_HTTP_VERSION    => CURL_HTTP_VERSION_1_1,
          CURLOPT_RETURNTRANSFER  => true,
          CURLOPT_TIMEOUT         => 30,
          CURLOPT_HTTPHEADER      => $httpHeader
        ];

        curl_setopt_array($curl, $curlOPT);

        $response = curl_exec($curl);
        $responseInfo = json_decode($response, true);

        curl_close($curl);

        // put some data in session before redirect to mercadopago url
        $request->session()->put('bookingId', $booking_details->id);   // db row number

        if ($this->sandbox_status == 1) {
          return redirect($responseInfo['sandbox_init_point']);
        } else {
          return redirect($responseInfo['init_point']);
        }
    
   }else{
     return redirect()->back()->with('error', __('Please Contact Support'));
   }
  }

  public function notify(Request $request)
  {
    // get the information from session
    $bookingId = $request->session()->get('bookingId');

    if ($request['status'] == 'approved') {
      // update the payment status for package booking in database
      $bookingInfo = PackageBooking::findOrFail($bookingId);

      $bookingInfo->update(['payment_status' => 1]);

      $packageBooking = new PackageBookingController();

      // generate an invoice in pdf format
      $invoice = $packageBooking->generateInvoice($bookingInfo);

      // update the invoice field information in database
      $bookingInfo->update(['invoice' => $invoice]);

      // send a mail to the customer with an invoice
      $packageBooking->sendMail($bookingInfo);

      // remove all session data
      $request->session()->forget('bookingId');

      return redirect()->route('package_booking.complete',getParam());
    } else {
      return redirect()->route('package_booking.cancel',getParam());
    }
  }

  public function curlCalls($url)
  {
    $curl = curl_init();

    curl_setopt($curl, CURLOPT_URL, $url);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);

    $curlData = curl_exec($curl);

    curl_close($curl);

    return $curlData;
  }
}
