<?php

namespace App\Http\Controllers\FrontEnd\Package;

use App\Http\Controllers\Controller;
use App\Http\Controllers\FrontEnd\Package\PackageBookingController;
use App\Http\Helpers\LimitCheckerHelper;
use App\Models\Language;
use App\Models\User\PackageBooking;
use App\Models\User\PaymentGateway;
use App\Traits\MiscellaneousTrait;
use Illuminate\Http\Request;
use Omnipay\Omnipay;

class AuthorizenetController extends Controller
{
    public $gateway;
    public $paypalData;

    public function __construct()
    {
        $data = PaymentGateway::whereKeyword('authorize.net')->where('user_id', getUser()->id)->first();
        $this->paypalData = json_decode($data->information, true);
        $paydata       = $data->convertAutoData();
        $this->gateway = Omnipay::create('AuthorizeNetApi_Api');
        $this->gateway->setAuthName($paydata['login_id']);
        $this->gateway->setTransactionKey($paydata['transaction_key']);
        if ($paydata['sandbox_check'] == 1) {
            $this->gateway->setTestMode(true);
        }
    }

    public function bookingProcess(Request $request)
    {
        if (empty($this->paypalData)) {
            return back()->with('error', __('Payment credentails not set yet'));
        }
        $countPackageBooking = LimitCheckerHelper::packageBookingCountUser(getUser()->id);
        $PackageBookingLimit = LimitCheckerHelper::packageBookingsLimit(getUser()->id);
        if ($PackageBookingLimit > $countPackageBooking) {
            $PackageBooking = new PackageBookingController();
            // do calculation
            $calculatedData     = $PackageBooking->calculation($request);
            $available_currency = ['BIF', 'CAD', 'CDF', 'CVE', 'EUR', 'GBP', 'GHS', 'GMD', 'GNF', 'KES', 'LRD', 'MWK', 'NGN', 'RWF', 'SLL', 'STD', 'TZS', 'UGX', 'USD', 'XAF', 'XOF', 'ZMK', 'ZMW', 'ZWD'];
            $currencyInfo       = MiscellaneousTrait::getCurrencyInfo();

            // checking whether the base currency is allowed or not
            if (! in_array($currencyInfo->base_currency_text, $available_currency)) {
                return redirect()->back()->with('error', __('Invalid currency for authorize.net payment.'));
            }

            $information['subtotal']                 = $calculatedData['subtotal'];
            $information['discount']                 = $calculatedData['discount'];
            $information['total']                    = $calculatedData['total'];
            $information['userTotal']                = $calculatedData['userTotal'];
            $information['tax']                      = $calculatedData['tax'];
            $information['fee']                      = $calculatedData['fee'];
            $information['currency_symbol']          = $currencyInfo->base_currency_symbol;
            $information['currency_symbol_position'] = $currencyInfo->base_currency_symbol_position;
            $information['currency_text']            = $currencyInfo->base_currency_text;
            $information['currency_text_position']   = $currencyInfo->base_currency_text_position;
            $information['method']                   = 'authorize.net';
            $information['type']                     = 'online';

            // store the room booking information in database
            $booking_details = $PackageBooking->storeData($request, $information);
            if ($request->input('opaqueDataDescriptor') && $request->input('opaqueDataValue')) {
                try {
                    // Generate a unique merchant site transaction ID.
                    $transactionId = rand(100000000, 999999999);
                    $response      = $this->gateway->authorize([
                        'amount'               => intval($calculatedData['total']),
                        'currency'             => $booking_details->base_currency_text,
                        'transactionId'        => $transactionId,
                        'opaqueDataDescriptor' => $request->input('opaqueDataDescriptor'),
                        'opaqueDataValue'      => $request->input('opaqueDataValue'),
                    ])->send();
                } catch (\Exception $e) {
                }
                if ($response->isSuccessful()) {

                    // Captured from the authorization response.
                    $transactionReference = $response->getTransactionReference();

                    $response = $this->gateway->capture([
                        'amount'               => intval($calculatedData['total']),
                        'currency'             => $booking_details->base_currency_text,
                        'transactionReference' => $transactionReference,
                    ])->send();

                    $bookingInfo = PackageBooking::findOrFail($booking_details->id);
                    $bookingInfo->update(['payment_status' => 1]);
                    $PackageBooking = new PackageBookingController();
                    // generate an invoice in pdf format
                    $invoice = $PackageBooking->generateInvoice($bookingInfo);
                    // update the invoice field information in database
                    $bookingInfo->update(['invoice' => $invoice]);
                    // send a mail to the customer with an invoice
                    $PackageBooking->sendMail($bookingInfo);
                    // remove all session data
                    $request->session()->forget('bookingId');
                    $request->session()->forget('paymentId');

                    return redirect()->route('room_booking.complete', getParam());
                } else {
                    return redirect()->route('room_booking.cancel', getParam());
                }
            }
        } else {
            return redirect()->back()->with('error', __('Please Contact Support'));
        }
    }
}
