<?php

namespace App\Http\Controllers\FrontEnd;

use App\Http\Controllers\Controller;
use App\Models\User\Gallery;
use App\Models\User\GalleryCategory;
use App\Traits\MiscellaneousTrait;

class GalleryController extends Controller
{
  use MiscellaneousTrait;

  public function gallery()
  {
    $user = getuser();
    $queryResult['breadcrumbInfo'] = MiscellaneousTrait::getBreadcrumb();
    $language = MiscellaneousTrait::getLanguage();
    $queryResult['pageHeading'] = $this->getUserPageHeading($language, $user->id);

    $queryResult['categories'] = GalleryCategory::where('language_id', $language->id)
      ->where('status', 1)
      ->where('user_id', $user->id)
      ->orderBy('serial_number', 'asc')
      ->get();

    $queryResult['galleryInfos'] = Gallery::with('galleryCategory')
      ->where('language_id', $language->id)
      ->where('user_id', $user->id)
      ->orderBy('serial_number', 'asc')
      ->get();
    $queryResult['seo'] = $this->getUserSeoData($language, $user->id);
    return view('user-front.common.gallery.gallery', $queryResult);
  }
}
