<?php

namespace App\Http\Controllers\FrontEnd;

use App\Http\Controllers\Controller;
use App\Models\User\FAQ;
use App\Models\User\HomePage\SectionHeading;
use App\Traits\MiscellaneousTrait;

class FAQController extends Controller
{
  use MiscellaneousTrait;

  public function faqs()
  {
    $user = getUser();
    $settings = $user->basic_setting;
    if(!in_array($settings->theme_version,['theme_two'])){
      return view('errors.user-404');
    }
    $queryResult['breadcrumbInfo'] = MiscellaneousTrait::getBreadcrumb();
    $language = MiscellaneousTrait::getLanguage();
    $queryResult['pageHeading'] = $this->getUserPageHeading($language, $user->id);
    $queryResult['seo'] = $this->getUserSeoData($language, $user->id);

    $queryResult['secHeading'] = SectionHeading::where('language_id', $language->id)->where('user_id', $user->id)
      ->select('faq_section_title', 'faq_section_subtitle', 'faq_section_image')
      ->first();
    $queryResult['faqs'] = FAQ::where('language_id', $language->id)->where('user_id', $user->id)
      ->orderby('serial_number', 'asc')
      ->get();
    return view('user-front.common.faqs', $queryResult);
  }
}
