<?php

namespace App\Http\Controllers\FrontEnd;

use Illuminate\Http\Request;
use App\Http\Helpers\MegaMailer;
use App\Traits\MiscellaneousTrait;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;

class ContactController extends Controller
{
  use MiscellaneousTrait;

  public function __construct()
  {
    $user = getUser();
    $bs = $user->basic_setting;
    Config::set('captcha.sitekey', $bs->google_recaptcha_site_key);
    Config::set('captcha.secret', $bs->google_recaptcha_secret_key);
  }

  public function contact($domain)
  {

    $user = getUser();
    $language = MiscellaneousTrait::getLanguage();
    $queryResult['seo'] = $this->getUserSeoData($language, $user->id);
    $queryResult['breadcrumbInfo'] = MiscellaneousTrait::getBreadcrumb();
    $queryResult['pageHeading'] = $this->getUserPageHeading($language, $user->id);
  
    return view('user-front.common.contact', $queryResult);
  }

  public function sendMail(Request $request)
  {
    $keywords = get_keywords(getUser()->id);
    $rules = [
      'full_name' => 'required',
      'email' => 'required|email:rfc,dns',
      'subject' => 'required',
      'message' => 'required'
    ];

    $messages = [
      'full_name.required' => $keywords['The full name field is required.'] ?? __('The full name field is required.'),
      'email.required' => $keywords['The email field is required.'] ?? __('The email field is required.'),
      'subject.required' => $keywords['The subject field is required.'] ?? __('The subject field is required.'),
      'email.email' => $keywords['Please enter validated email.'] ?? __('Please enter validated email.'),
      'message.required' => $keywords['The message field is required.'] ?? __('The message field is required.'),
    ];
   
    $bs = DB::table('user_basic_settings')->select('google_recaptcha_status')->first();

    if ($bs->google_recaptcha_status == 1) {
      $rules['g-recaptcha-response'] = 'required|captcha';
    }
       $messages['g-recaptcha-response.required'] = $keywords['Please verify that you are not a robot.'] ?? __('Please verify that you are not a robot.');
      $messages['g-recaptcha-response.captcha'] = $keywords['Captcha error! try again later or contact site admin.'] ?? __('Captcha error! try again later or contact site admin.');

    $validator = Validator::make($request->all(), $rules, $messages);
    if ($validator->fails()) {
      return redirect()->back()->withErrors($validator->errors());
    }

    $toUser = getUser();

    $data['toMail'] = $toUser->email;
    $data['toName'] = $toUser->username;
    $data['subject'] = $request->subject;
    $data['body'] = "<div>$request->message</div><br>
                         <strong>For further contact with the enquirer please use the below information:</strong><br>
                         <strong>Enquirer Name:</strong> $request->full_name <br>
                         <strong>Enquirer Mail:</strong> $request->email <br>
                         ";
    $data['fullname'] = $request->full_name;
    $data['email'] = $request->email;
    $mailer = new MegaMailer();
    $mailer->mailContactMessage($data);
    Session::flash('success', $keywords['Email sent successfully!'] ?? 'Email sent successfully!');
    return back();
  }
}
