<?php

namespace App\Http\Controllers\FrontEnd;

use App\Http\Controllers\Controller;
use App\Models\User\Journal\BlogCategory;
use App\Models\User\Journal\BlogInformation;
use App\Traits\MiscellaneousTrait;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class BlogController extends Controller
{
  use MiscellaneousTrait;

  public function blogs($domain, Request $request)
  {
    $user = getUser();
    $queryResult['breadcrumbInfo'] = MiscellaneousTrait::getBreadcrumb();
    $language = MiscellaneousTrait::getLanguage();
    $queryResult['pageHeading'] = $this->getUserPageHeading($language, $user->id);
    $queryResult['seo'] = $this->getUserSeoData($language, $user->id);

    $blog_name = $category_id = null;

    if ($request->filled('term')) {
      $blog_name = $request->term;
    }

    if ($request->filled('category')) {
      $category_id = $request->category;
    }

    $queryResult['blogInfos'] = DB::table('user_blogs')
      ->join('user_blog_informations', 'user_blogs.id', '=', 'user_blog_informations.blog_id')
      ->where('user_blog_informations.language_id', '=', $language->id)
      ->where('user_blogs.user_id', '=', $user->id)
      ->where('user_blog_informations.user_id', '=', $user->id)
      ->when($blog_name, function ($query, $blog_name) {
        return $query->where('title', 'like', '%' . $blog_name . '%');
      })->when($category_id, function ($query) use ($category_id,$user) {
        $cat = BlogCategory::where('user_id',$user->id)->where('slug', $category_id)->first();
        if(!is_null($cat)){
          return $query->where('user_blogs.category_index', '=', $cat->indx);
        }
      })
      ->orderBy('user_blogs.serial_number', 'asc')
      ->paginate(3);
      
    

    $queryResult['recentBlogs'] = $this->getRecentBlogs();

    $queryResult['blogCategories'] = $this->getBlogCategories();
    return view('user-front.common.blog.blogs', $queryResult);
  }

  public function blogDetails($domain, $slug)
  {
 
    $user = getUser();
    $queryResult['breadcrumbInfo'] = MiscellaneousTrait::getBreadcrumb();
    $language = MiscellaneousTrait::getLanguage();
    $queryResult['seo'] = $this->getUserSeoData($language, $user->id);
    $queryResult['details'] = BlogInformation::with('blog')
      ->where('language_id', $language->id)
      ->where('slug', $slug)
      ->where('user_id', $user->id)
      ->firstOrFail();

    $id = $queryResult['details']->blog_id;

    $queryResult['recentBlogs'] = $this->getRecentBlogs($id);
    $queryResult['blogCategories'] = $this->getBlogCategories();

    return view('user-front.common.blog.blog_details', $queryResult);
  }
}
