<?php

namespace App\Http\Controllers\Front;

use App\Enums\ThemeVersion;
use App\Http\Controllers\Controller;
use App\Http\Controllers\Payment\AuthorizenetController;
use App\Http\Controllers\Payment\FlutterWaveController;
use App\Http\Controllers\Payment\InstamojoController;
use App\Http\Controllers\Payment\MercadopagoController;
use App\Http\Controllers\Payment\MollieController;
use App\Http\Controllers\Payment\PaypalController;
use App\Http\Controllers\Payment\PaystackController;
use App\Http\Controllers\Payment\PaytmController;
use App\Http\Controllers\Payment\RazorpayController;
use App\Http\Controllers\Payment\StripeController;
use App\Http\Helpers\MegaMailer;
use App\Http\Helpers\UserPermissionHelper;
use App\Http\Requests\Checkout\CheckoutRequest;
use App\Models\Coupon;
use App\Models\Language;
use App\Models\Membership;
use App\Models\OfflineGateway;
use App\Models\Package;
use App\Models\User;
use App\Models\User\PaymentGateway;
use App\Models\User\MailTemplate;
use App\Models\User\PageHeading;
use App\Models\User\UserPermission;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use App\Models\Language as AdminLaguage;
use App\Models\User\HomePage\SectionHeading;

class CheckoutController extends Controller
{
    public function checkout(CheckoutRequest $request)
    {
      
        $coupon = Coupon::where('code', Session::get('coupon'))->first();
        if (!empty($coupon)) {
            $coupon_count = $coupon->total_uses;
            if ($coupon->maximum_uses_limit != 999999) {
                if ($coupon_count == $coupon->maximum_uses_limit) {
                    Session::forget('coupon');
                    session()->flash('warning', __('This coupon reached maximum limit'));
                    return redirect()->back();
                }
            }
        }

        $offline_payment_gateways = OfflineGateway::all()->pluck('name')->toArray();
        $currentLang = session()->has('lang') ?
            (Language::where('code', session()->get('lang'))->first())
            : (Language::where('is_default', 1)->first());
        $bs = $currentLang->basic_setting;
        $be = $currentLang->basic_extended;
        $request['status'] = 1;
        $request['mode'] = 'online';
        $request['receipt_name'] = null;
        Session::put('paymentFor', 'membership');
        $title = "You are purchasing a membership";
        $description = "Congratulation you are going to join our membership.Please make a payment for confirming your membership now!";
        if ($request->package_type == "trial") {
            $package = Package::find($request['package_id']);
            $request['price'] = 0.00;
            $request['payment_method'] = "-";
            $transaction_id = UserPermissionHelper::uniqidReal(8);
            $transaction_details = "Trial";
            $user = $this->store($request->all(), $transaction_id, $transaction_details, $request->price, $be, $request->password);

            $lastMemb = $user->memberships()->orderBy('id', 'DESC')->first();
            $activation = Carbon::parse($lastMemb->start_date);
            $expire = Carbon::parse($lastMemb->expire_date);
            $file_name = $this->makeInvoice($request->all(), "membership", $user, $request->password, $request['price'], "Trial", $request['phone'], $be->base_currency_symbol_position, $be->base_currency_symbol, $be->base_currency_text, $transaction_id, $package->title, $lastMemb);

            $mailer = new MegaMailer();
            $data = [
                'toMail' => $user->email,
                'toName' => $user->fname,
                'username' => $user->username,
                'package_title' => $package->title,
                'package_price' => ($be->base_currency_text_position == 'left' ? $be->base_currency_text . ' ' : '') . $package->price . ($be->base_currency_text_position == 'right' ? ' ' . $be->base_currency_text : ''),
                'activation_date' => $activation->toFormattedDateString(),
                'expire_date' => Carbon::parse($expire->toFormattedDateString())->format('Y') == '9999' ? 'Lifetime' : $expire->toFormattedDateString(),
                'membership_invoice' => $file_name,
                'website_title' => $bs->website_title,
                'templateType' => 'registration_with_trial_package',
                'type' => 'registrationWithTrialPackage'
            ];
            $mailer->mailFromAdmin($data);
            session()->flash('success', __('Payment Success'));
            return redirect()->route('membership.trial.success');
        } elseif ($request->price == 0) {
            $package = Package::find($request['package_id']);
            $request['price'] = 0.00;
            $request['payment_method'] = "-";
            $transaction_id = UserPermissionHelper::uniqidReal(8);
            $transaction_details = "Free";
            $user = $this->store($request->all(), $transaction_id, $transaction_details, $request->price, $be, $request->password);

            $lastMemb = $user->memberships()->orderBy('id', 'DESC')->first();
            $activation = Carbon::parse($lastMemb->start_date);
            $expire = Carbon::parse($lastMemb->expire_date);
            $file_name = $this->makeInvoice($request->all(), "membership", $user, $request->password, $request['price'], "Free", $request['phone'], $be->base_currency_symbol_position, $be->base_currency_symbol, $be->base_currency_text, $transaction_id, $package->title, $lastMemb);

            if (Session::has('coupon_amount')) {
                $mailTemp = 'registration_with_premium_package';
                $mailType = 'registrationWithPremiumPackage';
            } else {
                $mailTemp = 'registration_with_free_package';
                $mailType = 'registrationWithFreePackage';
            }

            $mailer = new MegaMailer();
            $data = [
                'toMail' => $user->email,
                'toName' => $user->fname,
                'username' => $user->username,
                'package_title' => $package->title,
                'package_price' => ($be->base_currency_text_position == 'left' ? $be->base_currency_text . ' ' : '') . $package->price . ($be->base_currency_text_position == 'right' ? ' ' . $be->base_currency_text : ''),
                'activation_date' => $activation->toFormattedDateString(),
                'expire_date' => Carbon::parse($expire->toFormattedDateString())->format('Y') == '9999' ? 'Lifetime' : $expire->toFormattedDateString(),
                'membership_invoice' => $file_name,
                'website_title' => $bs->website_title,
                'templateType' => $mailTemp,
                'type' => $mailType
            ];

            if (Session::has('coupon_amount')) {
                $data['discount'] = ($be->base_currency_text_position == 'left' ? $be->base_currency_text . ' ' : '') . $lastMemb->discount . ($be->base_currency_text_position == 'right' ? ' ' . $be->base_currency_text : '');
                $data['total'] = ($be->base_currency_text_position == 'left' ? $be->base_currency_text . ' ' : '') . $lastMemb->price . ($be->base_currency_text_position == 'right' ? ' ' . $be->base_currency_text : '');
            }

            $mailer->mailFromAdmin($data);
            session()->flash('success', __('Payment Success'));
            return redirect()->route('success.page');
        } elseif ($request->payment_method == "PayPal") {
            $amount = round(($request->price / $be->base_currency_rate), 2);
            $paypal = new PaypalController();
            $cancel_url = route('membership.paypal.cancel');
            $success_url = route('membership.paypal.success');
            return $paypal->paymentProcess($request, $amount, $title, $success_url, $cancel_url);
        } elseif ($request->payment_method == "Stripe") {
            $amount = round(($request->price / $be->base_currency_rate), 2);
            $stripe = new StripeController();
            $cancel_url = route('membership.stripe.cancel');
            return $stripe->paymentProcess($request, $amount, $title, NULL, $cancel_url);
        } elseif ($request->payment_method == "Paytm") {
            if ($be->base_currency_text != "INR") {
                return redirect()->back()->with('error', __('only_paytm_INR'))->withInput($request->all());
            }
            $amount = $request->price;
            $item_number = uniqid('paytm-') . time();
            $callback_url = route('membership.paytm.status');
            $paytm = new PaytmController();
            return $paytm->paymentProcess($request, $amount, $item_number, $callback_url);
        } elseif ($request->payment_method == "Paystack") {
            if ($be->base_currency_text != "NGN") {
                return redirect()->back()->with('error', __('only_paystack_NGN'))->withInput($request->all());
            }
            $amount = $request->price * 100;
            $email = $request->email;
            $success_url = route('membership.paystack.success');
            $payStack = new PaystackController();
            return $payStack->paymentProcess($request, $amount, $email, $success_url, $be);
        } elseif ($request->payment_method == "Razorpay") {
            if ($be->base_currency_text != "INR") {
                return redirect()->back()->with('error', __('only_razorpay_INR'))->withInput($request->all());
            }
            $amount = $request->price;
            $item_number = uniqid('razorpay-') . time();
            $cancel_url = route('membership.razorpay.cancel');
            $success_url = route('membership.razorpay.success');
            $razorpay = new RazorpayController();
            return $razorpay->paymentProcess($request, $amount, $item_number, $cancel_url, $success_url, $title, $description, $bs, $be);
        } elseif ($request->payment_method == "Instamojo") {
            if ($be->base_currency_text != "INR") {
                return redirect()->back()->with('error', __('only_instamojo_INR'))->withInput($request->all());
            }
            if ($request->price < 9) {
                session()->flash('warning', 'Minimum 10 INR required for this payment gateway');
                return back()->withInput($request->all());
            }
            $amount = $request->price;
            $success_url = route('membership.instamojo.success');
            $cancel_url = route('membership.instamojo.cancel');
            $instaMojo = new InstamojoController();
            return $instaMojo->paymentProcess($request, $amount, $success_url, $cancel_url, $title, $be);
        } elseif ($request->payment_method == "Mercado Pago") {
            if ($be->base_currency_text != "BRL") {
                return redirect()->back()->with('error', __('only_mercadopago_BRL'))->withInput($request->all());
            }
            $amount = $request->price;
            $email = $request->email;
            $success_url = route('membership.mercadopago.success');
            $cancel_url = route('membership.mercadopago.cancel');
            $mercadopagoPayment = new MercadopagoController();
            return $mercadopagoPayment->paymentProcess($request, $amount, $success_url, $cancel_url, $email, $title, $description, $be);
        } elseif ($request->payment_method == "Flutterwave") {
            $available_currency = array(
                'BIF', 'CAD', 'CDF', 'CVE', 'EUR', 'GBP', 'GHS', 'GMD', 'GNF', 'KES', 'LRD', 'MWK', 'NGN', 'RWF', 'SLL', 'STD', 'TZS', 'UGX', 'USD', 'XAF', 'XOF', 'ZMK', 'ZMW', 'ZWD'
            );
            if (!in_array($be->base_currency_text, $available_currency)) {
                return redirect()->back()->with('error', __('invalid_currency'))->withInput($request->all());
            }
            $amount = round(($request->price / $be->base_currency_rate), 2);
            $email = $request->email;
            $item_number = uniqid('flutterwave-') . time();
            $cancel_url = route('membership.flutterwave.cancel');
            $success_url = route('membership.flutterwave.success');
            $flutterWave = new FlutterWaveController();
            return $flutterWave->paymentProcess($request, $amount, $email, $item_number, $success_url, $cancel_url, $be);
        } elseif ($request->payment_method == "Authorize.net") {
            $available_currency = array('USD', 'CAD', 'CHF', 'DKK', 'EUR', 'GBP', 'NOK', 'PLN', 'SEK', 'AUD', 'NZD');
            if (!in_array($be->base_currency_text, $available_currency)) {
                return redirect()->back()->with('error', __('invalid_currency'))->withInput($request->all());
            }
            $amount = $request->price;
            $cancel_url = route('membership.anet.cancel');
            $anetPayment = new AuthorizenetController();
            return $anetPayment->paymentProcess($request, $amount, $cancel_url, $title, $be);
        } elseif ($request->payment_method == "Mollie Payment") {
            $available_currency = array('AED', 'AUD', 'BGN', 'BRL', 'CAD', 'CHF', 'CZK', 'DKK', 'EUR', 'GBP', 'HKD', 'HRK', 'HUF', 'ILS', 'ISK', 'JPY', 'MXN', 'MYR', 'NOK', 'NZD', 'PHP', 'PLN', 'RON', 'RUB', 'SEK', 'SGD', 'THB', 'TWD', 'USD', 'ZAR');
            if (!in_array($be->base_currency_text, $available_currency)) {
                return redirect()->back()->with('error', __('invalid_currency'))->withInput($request->all());
            }
            $amount = round(($request->price / $be->base_currency_rate), 2);
            $success_url = route('membership.mollie.success');
            $cancel_url = route('membership.mollie.cancel');
            $molliePayment = new MollieController();
            return $molliePayment->paymentProcess($request, $amount, $success_url, $cancel_url, $title, $be);
        } elseif (in_array($request->payment_method, $offline_payment_gateways)) {
            $request['mode'] = 'offline';
            $request['status'] = 0;
            $request['receipt_name'] = null;
            if ($request->has('receipt')) {
                $filename = time() . '.' . $request->file('receipt')->getClientOriginalExtension();
                $directory = public_path("assets/front/img/membership/receipt");
                if (!file_exists($directory)) mkdir($directory, 0775, true);
                $request->file('receipt')->move($directory, $filename);
                $request['receipt_name'] = $filename;
            }
            $amount = round(($request->price / $be->base_currency_rate), 2);
            $transaction_id = UserPermissionHelper::uniqidReal(8);
            $transaction_details = "offline";
            $password = $request->password;
            $this->store($request, $transaction_id, json_encode($transaction_details), $amount, $be, $password);
            
            session()->flash('success', __('Payment Success'));
            return redirect()->route('membership.offline.success');
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store($request, $transaction_id, $transaction_details, $amount, $be, $password)
    {
        if (session()->has('lang')) {
            $currentLang = Language::where('code', session()->get('lang'))->first();
        } else {
            $currentLang = Language::where('is_default', 1)->first();
        }
        $bs = $currentLang->basic_setting;
        $token = md5(time() . $request['username'] . $request['email']);
        $verification_link = "<a href='" . url('register/mode/' . $request['mode'] . '/verify/' . $token) . "'>" . "<button type=\"button\" class=\"btn btn-primary\">Click Here</button>" . "</a>";
        
        $user = User::where('username', $request['username']);
        if ($user->count() == 0) {
            $user = User::create([
                'first_name' => $request['first_name'],
                'last_name' => $request['last_name'],
                'company_name' => $request['company_name'],
                'email' => $request['email'],
                'phone' => $request['phone'],
                'username' => $request['username'],
                'password' => bcrypt($password),
                'status' => $request["status"],
                'address' => $request["address"] ? $request["address"] : null,
                'city' => $request["city"] ? $request["city"] : null,
                'state' => $request["district"] ? $request["district"] : null,
                'country' => $request["country"] ? $request["country"] : null,
                'verification_link' => $token,
            ]);

            if ($user) {
                $this->insertMailTemplate($user);
            }
            $this->tenant_lanuage_related_table_create($user);

            $mailer = new MegaMailer();
            $data = [
                'toMail' => $user->email,
                'toName' => $user->first_name,
                'customer_name' => $user->first_name,
                'verification_link' => $verification_link,
                'website_title' => $bs->website_title,
                'templateType' => 'email_verification',
                'type' => 'emailVerification'
            ];
            $mailer->mailFromAdmin($data);

            $package = Package::findOrFail($request['package_id']);
            Membership::create([
                'package_price' => $package->price,
                'discount' => session()->has('coupon_amount') ? session()->get('coupon_amount') : 0,
                'coupon_code' => session()->has('coupon') ? session()->get('coupon') : NULL,
                'price' => $amount,
                'currency' => $be->base_currency_text ?? "USD",
                'currency_symbol' => $be->base_currency_symbol ?? $be->base_currency_text,
                'payment_method' => $request["payment_method"],
                'transaction_id' => $transaction_id ?? 0,
                'status' => $request["status"] ? $request["status"] : 0,
                'is_trial' => $request["package_type"] == "regular" ? 0 : 1,
                'trial_days' => $request["package_type"] == "regular" ? 0 : $request["trial_days"],
                'receipt' => $request["receipt_name"] ? $request["receipt_name"] : null,
                'transaction_details' => $transaction_details ?? null,
                'settings' => json_encode($be),
                'package_id' => $request['package_id'],
                'user_id' => $user->id,
                'start_date' => Carbon::parse($request['start_date']),
                'expire_date' => Carbon::parse($request['expire_date']),
            ]);
            $features = json_decode($package->features, true);
            $features[] = "Contact";
            UserPermission::create([
                'package_id' => $request['package_id'],
                'user_id' => $user->id,
                'permissions' => json_encode($features)
            ]);

            User\Section::create([
                'user_id' => $user->id
            ]);
            
            User\BasicSetting::create([
                'theme_version' => ThemeVersion::ThemeOne->value,
                'email' => $user->email,
                'smtp_status' => 1,
                'email_address' => $user->email,
                'website_title' => $bs->website_title,
                'address' => $request["address"] ? $request["address"] : null,
                'base_currency_symbol_position' => $be->base_currency_symbol_position,
                'base_currency_symbol' => $be->base_currency_symbol ?? $be->base_currency_text,
                'base_currency_text' => $be->base_currency_text,
                'base_currency_text_position' => $be->base_currency_text_position,
                'base_currency_rate' => $be->base_currency_rate,
                'primary_color' => '0F172B',
                'secondary_color' => 'FEA116',
                'breadcrumb_overlay_color' => '0F172B',
                'breadcrumb_overlay_opacity' => 0.76,
                'contact_number' => $request['phone'],
                'user_id' => $user->id,
                'reply_to' =>  $user->email,
                'from_name' => 'Hotelia',
                'user_id' => $user->id,
                'room_guest_checkout_status' => 1,
                'package_guest_checkout_status' => 1

            ]);

            // create payment gateways
            $payment_keywords = ['flutterwave', 'razorpay', 'paytm', 'paystack', 'instamojo', 'stripe', 'paypal', 'mollie', 'mercadopago', 'authorize.net'];
            foreach ($payment_keywords as $key => $value) {
                PaymentGateway::create([
                    'title' => null,
                    'user_id' => $user->id,
                    'details' => null,
                    'keyword' => $value,
                    'subtitle' => null,
                    'name' => ucfirst($value),
                    'type' => 'automatic',
                    'information' => null,
                    'status' => 0
                ]);
            }
        }

        // coupon update
        if (Session::has('coupon')) {
            $coupon = Coupon::where('code', Session::get('coupon'))->first();
            $coupon->total_uses = $coupon->total_uses + 1;
            $coupon->save();
        }
        return $user;
    }

    public function insertMailTemplate($user)
    {
        $mailTemp = new MailTemplate();
        $mailTemp->user_id = $user->id;
        $mailTemp->mail_type = "room_booking_for_online_gateway";
        $mailTemp->mail_subject = "Confirmation of Room Booking For Online Gateway";
        $mailTemp->mail_body = "<p>Your room booking was successful</p><p><b>Name :</b> {customer_name}</p><p><b>Booking number:</b> {booking_number}</p><p><b>Booking date:</b> {booking_date}</p><p><b>Number of night:</b> {number_of_night}</p><p><b>Check in date:</b> {check_in_date}</p><p><b>Checkout date: </b>{check_out_date}</p><p><b>Number of guest:</b> {number_of_guests}</p><p><b>Room name:</b> {room_name}</p><p><b>Room rent:</b> {room_rent}</p><p><b>Discount:</b> {discount}</p><p><b>Room amenities:</b> {room_amenities}</p><p><b>Room Type:</b> {room_type}</p><p>{website_title}</p>";
        $mailTemp->save();

        $mailTemp = new MailTemplate();
        $mailTemp->user_id = $user->id;
        $mailTemp->mail_type = "room_booking_for_offline_gateway";
        $mailTemp->mail_subject = "Confirmation of Room Booking For Offline Gateway";
        $mailTemp->mail_body = "<p>Your room booking was successful</p><p><b>Name :</b> {customer_name}</p><p><b>Booking number:</b> {booking_number}</p><p><b>Booking date:</b> {booking_date}</p><p><b>Number of night:</b> {number_of_night}</p><p><b>Check in date:</b> {check_in_date}</p><p><b>Checkout date: </b>{check_out_date}</p><p><b>Number of guest:</b> {number_of_guests}</p><p><b>Room name:</b> {room_name}</p><p><b>Room rent:</b> {room_rent}</p><p><b>Discount:</b> {discount}</p><p><b>Room amenities:</b> {room_amenities}</p><p><b>Room Type:</b> {room_type}</p><p>{website_title}</p>";
        $mailTemp->save();

        $mailTemp = new MailTemplate();
        $mailTemp->user_id = $user->id;
        $mailTemp->mail_type = "package_booking_for_online_gateway";
        $mailTemp->mail_subject = "Confirmation of Package Booking for Online Gateway";
        $mailTemp->mail_body = "<p>Your package booking was successful</p><p><b>Customer name:</b> {customer_name}</p><p><b>Booking number:</b> {booking_number}</p><p><b>Package Name:</b> {package_name}</p><p><b>Package Price:</b> {package_price}</p><p><b>Discount:</b> {discount}</p><p><b>Number Of Visitors:</b> {number_of_visitors}</p><p>{website_title}</p>";
        $mailTemp->save();

        $mailTemp = new MailTemplate();
        $mailTemp->user_id = $user->id;
        $mailTemp->mail_type = "package_booking_for_offline_gateway";
        $mailTemp->mail_subject = "Confirmation of Package Booking for Offline Gateway";
        $mailTemp->mail_body = "<p>Your package booking was successful</p><p><b>Customer name:</b> {customer_name}</p><p><b>Booking number:</b> {booking_number}</p><p><b>Package Name:</b> {package_name}</p><p><b>Package Price:</b> {package_price}</p><p><b>Discount:</b> {discount}</p><p><b>Number Of Visitors:</b> {number_of_visitors}</p><p>{website_title}</p>";
        $mailTemp->save();


        $mailTemp = new MailTemplate();
        $mailTemp->user_id = $user->id;
        $mailTemp->mail_type = "room_booking_payment_cancelled";
        $mailTemp->mail_subject = "Room Booking Request is Rejected";
        $mailTemp->mail_body = "<p>Booking Request is Rejected</p><p>{customer_name}</p><p>{website_title}</p>";
        $mailTemp->save();

        $mailTemp = new MailTemplate();
        $mailTemp->user_id = $user->id;
        $mailTemp->mail_type = "package_booking_payment_cancelled";
        $mailTemp->mail_subject = "Package Booking Request is Rejected";
        $mailTemp->mail_body = "<p>Booking Request is Rejected</p><p>{customer_name}</p><p>{website_title}</p>";
        $mailTemp->save();
        

        $mailTemp = new MailTemplate();
        $mailTemp->user_id = $user->id;
        $mailTemp->mail_type = "room_booking_payment_received";
        $mailTemp->mail_subject = "Room Booking Confirmation of Payment Received";
        $mailTemp->mail_body = "<p>Confirmation of Payment Received</p><p>{customer_name}</p><p>{website_title}<br /></p>";
        $mailTemp->save();

        $mailTemp = new MailTemplate();
        $mailTemp->user_id = $user->id;
        $mailTemp->mail_type = "package_booking_payment_received";
        $mailTemp->mail_subject = "Package Booking Confirmation of Payment Received";
        $mailTemp->mail_body = "<p>Confirmation of Payment Received</p><p>{customer_name}</p><p>{website_title}<br /></p>";
        $mailTemp->save();

        $mailTemp = new MailTemplate();
        $mailTemp->user_id = $user->id;
        $mailTemp->mail_type = "verify_email";
        $mailTemp->mail_subject = "Verify Your Email Address";
        $mailTemp->mail_body = "<p> A verify link was sent to your email</p><p>{customer_name}</p><p>{customer_username}</p><p>{verification_link}</p><p>{website_title}</p>";
        $mailTemp->save();

        $mailTemp = new MailTemplate();
        $mailTemp->user_id = $user->id;
        $mailTemp->mail_type = "reset_password";
        $mailTemp->mail_subject = "Recover Password of Your Account";
        $mailTemp->mail_body = "<h4>Hello  {customer_name}</h4><p>{password_reset_link}</p><p>{website_title}<br /></p>";
        $mailTemp->save();
    }

    public function onlineSuccess()
    {
        Session::forget('coupon');
        Session::forget('coupon_amount');
        return view('front.success');
    }

    public function offlineSuccess()
    {
        Session::forget('coupon');
        Session::forget('coupon_amount');
        return view('front.offline-success');
    }

    public function trialSuccess()
    {
        Session::forget('coupon');
        Session::forget('coupon_amount');
        return view('front.trial-success');
    }

    public function coupon(Request $request)
    {
        if (session()->has('coupon')) {
            return __('Coupon already applied');
        }
        $coupon = Coupon::where('code', $request->coupon)->first();
        if (empty($coupon)) {
            return __('This coupon does not exist');
        }

        $coupon_count = $coupon->total_uses;
        if ($coupon->maximum_uses_limit != 999999) {
            if ($coupon_count >= $coupon->maximum_uses_limit) {
                return __('This coupon reached maximum limit');
            }
        }
        $start = Carbon::parse($coupon->start_date);
        $end = Carbon::parse($coupon->end_date);
        $today = Carbon::parse(Carbon::now()->format('m/d/Y'));
        $packages = $coupon->packages;
        $packages = json_decode($packages, true);
        $packages = !empty($packages) ? $packages : [];
        if (!in_array($request->package_id, $packages)) {
            return __('This coupon is not valid for this package');
        }

        if ($today->greaterThanOrEqualTo($start) && $today->lessThanOrEqualTo($end)) {
            $package = Package::find($request->package_id);
            $price = $package->price;
            if ($coupon->type == 'percentage') {
                $cAmount = ($price * $coupon->value) / 100;
            } else {
                $cAmount = $coupon->value;
            }

            Session::put('coupon', $request->coupon);
            Session::put('coupon_amount', round($cAmount, 2));
            return "success";
        } else {
            return __('This coupon does not exist');
        }
    }
    public function tenant_lanuage_related_table_create($user)
    {
        $adminLangs = AdminLaguage::get();
        $langCount = User\Language::where('user_id', $user->id)->where('is_default', 1)->count();
        if ($langCount == 0) {
            foreach ($adminLangs as $lang) {
                //======language create==========
                $language = User\Language::create([
                    'name' => $lang->name,
                    'code' => $lang->code,
                    'is_default' => $lang->is_default,
                    'dashboard_default' => $lang->dashboard_default,
                    'rtl' => $lang->rtl,
                    'user_id' => $user->id,
                    'keywords' => $lang->customer_keywords
                ]);

                //====start menus=====
                $menus = '[{"text":"Home","href":"","icon":"empty","target":"_self","title":"","type":"home"},{"text":"Services","href":"","icon":"empty","target":"_self","title":"","type":"service"},{"text":"Rooms","href":"","icon":"empty","target":"_self","title":"","type":"room"},{"text":"Packages","href":"","icon":"empty","target":"_self","title":"","type":"package"},{"text":"Blogs","href":"","icon":"empty","target":"_self","title":"","type":"blog"},{"text":"Gallery","href":"","icon":"empty","target":"_self","title":"","type":"gallery"},{"text":"Contact","href":"","icon":"empty","target":"_self","title":"","type":"contact"},{"type":"faq","text":"FAQ","href":"","target":"_self"}]';

                $userMenu = User\Menu::create([
                    'user_id' => $user->id,
                    'language_id' => $language->id,
                    'menus' => $menus,
                ]);

                //======= End Menu============

                // ======= start Page Headings====
                PageHeading::create([
                    "language_id" => $language->id,
                    "user_id" => $user->id,
                    'gallery_page_title' => 'Gallery',
                    'rooms_page_title' => 'Rooms',
                    'reset_password_page_title' => 'Reset Password',
                    'packages_page_title' => 'Packages',
                    'dashboard_page_title' => 'Dashboard',
                    'services_page_title' => 'Services',
                    'room_bookings_page_title' => 'Room  Bookings',
                    "blog_page_title" => "Blog",
                    "package_bookings_page_title" => "Package Bookings",
                    "contact_page_title" => "Contact",
                    "error_page_title" => "404",
                    "faq_page_title" => "FAQ",
                    "forget_password_page_title" => "Forget Password",
                    "login_page_title" => "Login",
                    "signup_page_title" => "Sign Up",
                    "edit_profile_page_title" => "Edit Profile",
                    "change_password_page_title" => "Change Password",
                    "reset_password_page_title" => "Reset Password",
                    "created_at" => null,
                    "updated_at" => null
                ]);
                //end Page Heading

                //===Section Heading create
                SectionHeading::create([
                    "language_id" => $language->id,
                    "user_id" => $user->id,
                ]);
                //===End Section Heading
                User\BasicExtended::create([
                    'user_id' => $user->id,
                    'language_id' => $language->id,
                ]);
            }
        }
        return;
    }
}
