<?php

namespace App\Http\Controllers;

use App\Models\User\BasicSetting;
use App\Models\User\Journal\BlogCategory;
use App\Models\User\Language;
use App\Models\User\PageHeading;
use App\Models\User\SEO as UserSeo;
use App\Traits\MiscellaneousTrait;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Request;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\URL;
use Barryvdh\DomPDF\Facade\Pdf;

class Controller extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;

    public function getUserCurrentLanguage($userId)
    {
        // get the current locale of this system
        if (Session::has('user_lang')) {
            $locale = Session::get('user_lang');
        }
        if (empty($locale)) {
            $language = Language::query()->where('is_default', 1)->where('user_id', $userId)->firstOrFail();
        } else {
            $language = Language::query()->where('code', $locale)->where('user_id', $userId)->firstOrFail();
        }
        return $language;
    }

    public function getUserPageHeading($language, $userId)
    {
        $pageHeading = null;
         if (URL::current() == Route::is('blogs')) {
            $pageHeading = PageHeading::query()->where('language_id', $language->id)->where('user_id', $userId)->select('blog_page_title')->first();
        } else if (URL::current() == Route::is('faqs')) {
            $pageHeading = PageHeading::query()->where('language_id', $language->id)->where('user_id', $userId)->select('faq_page_title')->first();
        } else if (URL::current() == Route::is('services')) {
            $pageHeading = PageHeading::query()->where('language_id', $language->id)->where('user_id', $userId)->select('services_page_title')->first();
        } else if (URL::current() == Route::is('rooms')) {
            $pageHeading = PageHeading::query()->where('language_id', $language->id)->where('user_id', $userId)->select('rooms_page_title')->first();
        } else if (URL::current() == Route::is('contact')) {
            $pageHeading = PageHeading::query()->where('language_id', $language->id)->where('user_id', $userId)->select('contact_page_title')->first();
        }
        else if (URL::current() == Route::is('gallery')) {
            $pageHeading = PageHeading::query()->where('language_id', $language->id)->where('user_id', $userId)->select('gallery_page_title')->first();
        } else if (URL::current() == Route::is('packages')) {
            $pageHeading = PageHeading::query()->where('language_id', $language->id)->where('user_id', $userId)->select('packages_page_title')->first();
        }
        else if (URL::current() == Route::is('customer.login')) {
            $pageHeading = PageHeading::query()->where('language_id', $language->id)->where('user_id', $userId)->select('login_page_title')->first();
        } else if (URL::current() == Route::is('customer.forget_password')) {
            $pageHeading = PageHeading::query()->where('language_id', $language->id)->where('user_id', $userId)->select('forget_password_page_title')->first();
        } else if (URL::current() == Route::is('customer.signup')) {
            $pageHeading = PageHeading::query()->where('language_id', $language->id)->where('user_id', $userId)->select('signup_page_title')->first();
        } else if (URL::current() == Route::is('customer.dashboard')) {
            $pageHeading = PageHeading::query()->where('language_id', $language->id)->where('user_id', $userId)->select('dashboard_page_title')->first();
        } else if (URL::current() == Route::is('customer.room_booking')) {
            $pageHeading = PageHeading::query()->where('language_id', $language->id)->where('user_id', $userId)->select('room_bookings_page_title')->first();
        } else if (URL::current() == Route::is('customer.package_bookings')) {
            $pageHeading = PageHeading::query()->where('language_id', $language->id)->where('user_id', $userId)->select('package_bookings_page_title')->first();
        } else if (URL::current() == Route::is('customer.edit_profile')) {
            $pageHeading = PageHeading::query()->where('language_id', $language->id)->where('user_id', $userId)->select('edit_profile_page_title')->first();
        } else if (URL::current() == Route::is('customer.change_password')) {
            $pageHeading = PageHeading::query()->where('language_id', $language->id)->where('user_id', $userId)->select('change_password_page_title')->first();
        } else if (URL::current() == Route::is('password.reset.form')) {
            $pageHeading = PageHeading::query()->where('language_id', $language->id)->where('user_id', $userId)->select('reset_password_page_title')->first();
        } else if (URL::current() == Route::is('front.user.about')) {
            $pageHeading = PageHeading::query()->where('language_id', $language->id)->where('user_id', $userId)->select('about_page_title')->first();
        }


        return $pageHeading;
    }
    public function getUserSeoData($language, $userId)
    {

        if (URL::current() == Route::is('blogs')) {
            $seoData = UserSeo::query()->where('language_id', $language->id)->where('user_id', $userId)->select('blogs_meta_keywords', 'blogs_meta_description')->first();
        } else if (URL::current() == Route::is('faqs')) {
            $seoData = UserSeo::query()->where('language_id', $language->id)->where('user_id', $userId)->select('faqs_meta_description', 'faqs_meta_keywords')->first();
        }else if (URL::current() == Route::is('contact')) {
            $seoData = UserSeo::query()->where('language_id', $language->id)->where('user_id', $userId)->select('contact_meta_description', 'contact_meta_keywords')->first();
        } else if (URL::current() == Route::is('customer.login')) {
            $seoData = UserSeo::query()->where('language_id', $language->id)->where('user_id', $userId)->select('login_meta_keywords', 'login_meta_description')->first();
        } else if (URL::current() == Route::is('customer.forget_password')) {
            $seoData = UserSeo::query()->where('language_id', $language->id)->where('user_id', $userId)->select('forget_password_meta_description', 'forget_password_meta_keywords')->first();
        } else if (URL::current() == Route::is('customer.signup')) {
            $seoData = UserSeo::query()->where('language_id', $language->id)->where('user_id', $userId)->select('sign_up_meta_keywords', 'sign_up_meta_description')->first();
        } else if (URL::current() == Route::is('front.user.detail.view')) {
            $seoData = UserSeo::query()->where('language_id', $language->id)->where('user_id', $userId)->select('home_meta_keywords', 'home_meta_description')->first();
        }else if (URL::current() == Route::is('services')) {
            $seoData = UserSeo::query()->where('language_id', $language->id)->where('user_id', $userId)->select('services_meta_description', 'services_meta_keywords')->first();
        } else if (URL::current() == Route::is('rooms')) {
            $seoData = UserSeo::query()->where('language_id', $language->id)->where('user_id', $userId)->select('rooms_meta_keywords', 'rooms_meta_description')->first();
        } else if (URL::current() == Route::is('packages')) {
            $seoData = UserSeo::query()->where('language_id', $language->id)->where('user_id', $userId)->select('packages_meta_keywords', 'packages_meta_description')->first();
        } else if (URL::current() == Route::is('gallery')) {
            $seoData = UserSeo::query()->where('language_id', $language->id)->where('user_id', $userId)->select('gallery_meta_keywords', 'gallery_meta_description')->first();
        } else if (URL::current() == Route::is('front.user.about')) {
            $seoData = UserSeo::query()->where('language_id', $language->id)->where('user_id', $userId)->select('about_meta_description', 'about_meta_keywords')->first();
        }
        else{
            $seoData = UserSeo::query()->where('language_id', $language->id)->where('user_id', $userId)->select('contact_meta_description', 'contact_meta_keywords', 'home_meta_keywords', 'home_meta_description')->first();  
        }

        return $seoData;
    }


    public function getUserCurrencyInfo($userId)
    {
        return BasicSetting::query()
            ->where('user_id', $userId)
            ->select(
                'base_currency_symbol',
                'base_currency_symbol_position',
                'base_currency_text',
                'base_currency_text_position',
                'base_currency_rate'
            )->first();

    }

    public function getUserBreadcrumb($userId)
    {
        return BasicSetting::query()->where('user_id', $userId)->select('breadcrumb')->first();
    }


    public function makeInvoice($request, $key, $member, $password, $amount, $payment_method, $phone, $base_currency_symbol_position, $base_currency_symbol, $base_currency_text, $order_id, $package_title, $membership)
    {
        $file_name = uniqid($key) . ".pdf";
        $pdf = Pdf::setOptions([
            'isHtml5ParserEnabled' => true, 
            'isRemoteEnabled' => true,
            'logOutputFile' => storage_path('logs/log.htm'),
            'tempDir' => storage_path('logs/')
        ])->loadView('pdf.membership', compact('request', 'member', 'password', 'amount', 'payment_method', 'phone', 'base_currency_symbol_position', 'base_currency_symbol', 'base_currency_text', 'order_id', 'package_title', 'membership'));
        $output = $pdf->output();
        @mkdir(public_path('assets/front/invoices/'), 0775, true);
        file_put_contents(public_path('assets/front/invoices/' . $file_name), $output);
        return $file_name;
    }


    public function getRecentBlogs($id = null)
    {
        $user = getuser();
        $language = MiscellaneousTrait::getLanguage();

        $recentBlogs = DB::table('user_blogs')
        ->join('user_blog_informations', 'user_blogs.id', '=', 'user_blog_informations.blog_id')
        ->where('user_blogs.language_id', '=', $language->id)
        ->where('user_blog_informations.language_id', '=', $language->id)
        ->where('user_blogs.user_id', '=', $user->id)
        ->where('user_blog_informations.user_id', '=', $user->id)
        ->when($id,function($blog)use ($id){
            $blog->where('user_blogs.id', '<>', $id);
        })
        ->orderBy('user_blogs.serial_number', 'asc')
        ->paginate(3);

        return $recentBlogs;
    }

    public function getBlogCategories()
    {
        $user = getuser();
        $language = MiscellaneousTrait::getLanguage();

        $blogCategories = BlogCategory::where('language_id', $language->id)->where('user_id', $user->id)
            ->orderBy('id', 'asc')
            ->get();

        return $blogCategories;
    }
    public function changeLanguage(Request $request)
    {
        // put the selected language in session
        $langCode = $request['lang_code'];

        $request->session()->put('currentLocaleCode', $langCode);

        return redirect()->back();
    }
    public function tax($amount, $per)
    {
            $tax = ($amount * $per) / 100;
            return round($tax, 2);
    }


}
