<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\BasicExtended;
use App\Models\Language;
use Illuminate\Support\Facades\Session;
use App\Models\BasicSetting as BS;
use Illuminate\Support\Facades\Validator;
use Mews\Purifier\Facades\Purifier;

class HerosectionController extends Controller
{
    public function imgtext(Request $request)
    {
        $lang = Language::where('code', $request->language)->firstOrFail();
        $data['lang_id'] = $lang->id;
        $data['abe'] = $lang->basic_extended;
        $data['abs'] = $lang->basic_setting;
        return view('admin.home.hero.img-text', $data);
    }

    public function update(Request $request, $langid)
    {
        $sideImg = $request->file('image');
        $hero_img_right = $request->file('hero_img_right');
        $allowedExts = array('jpg', 'png', 'jpeg');
        $rules = [
            'image' => [
                function ($attribute, $value, $fail) use ($request, $sideImg, $allowedExts) {
                    if ($request->hasFile('image')) {
                        $ext = $sideImg->getClientOriginalExtension();
                        if (!in_array($ext, $allowedExts)) {
                            return $fail(__("Only png, jpg, jpeg image is allowed"));
                        }
                    }
                },
            ],
            'hero_img_right' => [
                function ($attribute, $value, $fail) use ($request, $hero_img_right, $allowedExts) {
                    if ($request->hasFile('hero_img_right')) {
                        $ext = $hero_img_right->getClientOriginalExtension();
                        if (!in_array($ext, $allowedExts)) {
                            return $fail(__("Only png, jpg, jpeg image is allowed"));
                        }
                    }
                },
            ],
            'hero_section_title' => 'nullable|max:255',
            'hero_section_subtitle' => 'nullable|max:255',
            'hero_section_text' => 'nullable|max:255',
            'hero_section_button_text' => 'nullable|max:30',
            'hero_section_button_url' => 'nullable',
            'intro_title' => 'nullable|max:255',
            'intro_subtitle' => 'nullable|max:255',
            'intro_text' => 'nullable',
            'intro_section_button_text' => 'nullable|max:255',
            'intro_section_button_url' => 'nullable|max:255',
            'intro_section_video_url' => 'nullable|max:255',
        ];

        $validator = Validator::make($request->all(), $rules);
        if ($validator->fails()) {
            $validator->getMessageBag()->add('error', 'true');
            return response()->json($validator->errors());
        }

        $be = BasicExtended::where('language_id', $langid)->firstOrFail();
        $be->hero_section_title = $request->hero_section_title;
        $be->hero_section_subtitle = $request->hero_section_subtitle;
        $be->hero_section_text = $request->hero_section_text;
        $be->hero_section_button_text = $request->hero_section_button_text;
        $be->hero_section_button_url = $request->hero_section_button_url;
        if ($request->hasFile('image')) {
            @unlink(public_path('assets/front/img/' . $be->hero_img));
            $filename = uniqid() . '.' . $sideImg->getClientOriginalExtension();
            $sideImg->move(public_path('assets/front/img/'), $filename);
            $be->hero_img = $filename;
        }
        if ($request->hasFile('hero_img_right')) {
            @unlink(public_path('assets/front/img/' . $be->hero_img_right));
            $filename_2 = uniqid() . '.' . $hero_img_right->getClientOriginalExtension();
            $hero_img_right->move(public_path('assets/front/img/'), $filename_2);
            $be->hero_img_right = $filename_2;
        }
        $be->save();

        $bs = BS::where('language_id', $langid)->firstOrFail();
        //intro sections
        $input['intro_text'] = Purifier::clean($request->intro_text, 'youtube');
        $input['intro_title'] = $request->intro_title;
        $input['intro_subtitle'] = $request->intro_subtitle;
        $input['intro_section_button_text'] = $request->intro_section_button_text;
        $input['intro_section_button_url'] = $request->intro_section_button_url;
        $input['intro_section_video_url'] = $request->intro_section_video_url;
        //sections title
        $input['work_process_title'] = $request->work_process_title;
        $input['work_process_subtitle'] = $request->work_process_subtitle;
        $input['preview_templates_title'] = $request->preview_templates_title;
        $input['preview_templates_subtitle'] = $request->preview_templates_subtitle;
        $input['featured_users_title'] = $request->featured_users_title;
        $input['featured_users_subtitle'] = $request->featured_users_subtitle;
        $input['partner_title'] = $request->partner_title;
        $input['partner_subtitle'] = $request->partner_subtitle;
        $input['pricing_title'] = $request->pricing_title;
        $input['pricing_subtitle'] = $request->pricing_subtitle;
        $input['testimonial_title'] = $request->testimonial_title;
        $input['testimonial_subtitle'] = $request->testimonial_subtitle;
        $input['blog_title'] = $request->blog_title;
        $input['blog_subtitle'] = $request->blog_subtitle;
        $bs->update($input);
        

        Session::flash('success', __('Updated Successfully'));
        return "success";
    }

}
